/*
 * Decompiled with CFR 0.152.
 */
package io.v.android.impl.google.discovery.plugins.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.google.common.collect.ImmutableList;
import io.v.android.impl.google.discovery.plugins.ble.BluetoothGattReader;
import io.v.android.impl.google.discovery.plugins.ble.ConvertUtil;
import io.v.android.impl.google.discovery.plugins.ble.DeviceCache;
import io.v.android.v23.V;
import io.v.impl.google.lib.discovery.Plugin;
import io.v.impl.google.lib.discovery.UUIDUtil;
import io.v.v23.context.VContext;
import io.v.v23.discovery.AdId;
import io.v.x.ref.lib.discovery.AdInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.joda.time.Duration;

public class BlePlugin
implements Plugin {
    private static final String TAG = "BlePlugin";
    private static final int MTU = 23;
    private static final Duration defaultCacheDuration = Duration.standardSeconds((long)90L);
    private final SecureRandom random = new SecureRandom();
    private final Context androidContext;
    private BluetoothLeAdvertiser bluetoothLeAdvertise;
    private BluetoothLeScanner bluetoothLeScanner;
    private BluetoothGattServer bluetoothGattServer;
    private Map<AdId, BluetoothGattService> advertisements;
    private AdvertiseCallback advertiseCallback;
    private Set<Plugin.ScanHandler> scanners;
    private Set<String> pendingConnections;
    private DeviceCache deviceCache;
    private ScanCallback scanCallback;

    private boolean hasPermission(String perm) {
        return ContextCompat.checkSelfPermission((Context)this.androidContext, (String)perm) == 0;
    }

    public BlePlugin(VContext ctx, String host) throws Exception {
        this.androidContext = V.getAndroidContext(ctx);
        if (this.androidContext == null) {
            throw new IllegalStateException("androidContext not available");
        }
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) {
            throw new IllegalStateException("BluetoothAdapter not available");
        }
        if (!this.hasPermission("android.permission.ACCESS_COARSE_LOCATION") && !this.hasPermission("android.permission.ACCESS_FINE_LOCATION")) {
            throw new IllegalStateException("No permission on BluetoothAdapter");
        }
        this.bluetoothLeAdvertise = bluetoothAdapter.getBluetoothLeAdvertiser();
        this.bluetoothLeScanner = bluetoothAdapter.getBluetoothLeScanner();
        BluetoothManager manager = (BluetoothManager)this.androidContext.getSystemService("bluetooth");
        this.bluetoothGattServer = manager.openGattServer(this.androidContext, new BluetoothGattServerCallback(){

            public void onConnectionStateChange(BluetoothDevice device, int status, int newState) {
                super.onConnectionStateChange(device, status, newState);
            }

            public void onCharacteristicReadRequest(BluetoothDevice device, int requestId, int offset, BluetoothGattCharacteristic characteristic) {
                super.onCharacteristicReadRequest(device, requestId, offset, characteristic);
                byte[] total = characteristic.getValue();
                byte[] res = new byte[]{};
                if (offset < total.length) {
                    int finalByte = offset + 23 - 1;
                    if (finalByte > total.length) {
                        finalByte = total.length;
                    }
                    res = Arrays.copyOfRange(total, offset, finalByte);
                    BlePlugin.this.bluetoothGattServer.sendResponse(device, requestId, 0, 0, res);
                } else {
                    BlePlugin.this.bluetoothGattServer.sendResponse(device, requestId, 0, 0, res);
                }
            }
        });
        this.advertisements = new HashMap<AdId, BluetoothGattService>();
        this.scanners = new HashSet<Plugin.ScanHandler>();
        this.pendingConnections = new HashSet<String>();
        this.deviceCache = new DeviceCache(defaultCacheDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAdvertising(AdInfo adInfo) throws Exception {
        BluetoothGattService service = new BluetoothGattService(UUIDUtil.serviceUUID((String)adInfo.getAd().getInterfaceName()), 0);
        for (Map.Entry<UUID, byte[]> entry : ConvertUtil.toGattAttrs(adInfo).entrySet()) {
            BluetoothGattCharacteristic c = new BluetoothGattCharacteristic(entry.getKey(), 2, 1);
            c.setValue(entry.getValue());
            service.addCharacteristic(c);
        }
        Map<AdId, BluetoothGattService> map = this.advertisements;
        synchronized (map) {
            this.advertisements.put(adInfo.getAd().getId(), service);
            this.bluetoothGattServer.addService(service);
            this.updateAdvertising();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAdvertising(AdInfo adInfo) {
        Map<AdId, BluetoothGattService> map = this.advertisements;
        synchronized (map) {
            BluetoothGattService service = this.advertisements.remove(adInfo.getAd().getId());
            if (service != null) {
                this.bluetoothGattServer.removeService(service);
                this.updateAdvertising();
            }
        }
    }

    private long genStamp() {
        return new BigInteger(64, this.random).longValue();
    }

    private void updateAdvertising() {
        if (this.advertiseCallback != null) {
            this.bluetoothLeAdvertise.stopAdvertising(this.advertiseCallback);
            this.advertiseCallback = null;
        }
        if (this.advertisements.size() == 0) {
            return;
        }
        AdvertiseData.Builder builder = new AdvertiseData.Builder();
        ByteBuffer buf = ByteBuffer.allocate(9);
        buf.put((byte)8);
        buf.putLong(this.genStamp());
        builder.addManufacturerData(1001, buf.array());
        AdvertiseSettings.Builder settingsBuilder = new AdvertiseSettings.Builder();
        settingsBuilder.setAdvertiseMode(2);
        settingsBuilder.setConnectable(true);
        this.advertiseCallback = new AdvertiseCallback(){

            public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                Log.d((String)BlePlugin.TAG, (String)("started " + settingsInEffect));
            }

            public void onStartFailure(int errorCode) {
                Log.e((String)BlePlugin.TAG, (String)("failed to start advertising " + errorCode));
            }
        };
        this.bluetoothLeAdvertise.startAdvertising(settingsBuilder.build(), builder.build(), this.advertiseCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startScan(String interfaceName, Plugin.ScanHandler handler) throws Exception {
        Set<Plugin.ScanHandler> set = this.scanners;
        synchronized (set) {
            if (!this.scanners.add(handler)) {
                throw new IllegalArgumentException("handler already registered");
            }
            this.deviceCache.addScanner(interfaceName, handler);
            this.updateScan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopScan(Plugin.ScanHandler handler) {
        Set<Plugin.ScanHandler> set = this.scanners;
        synchronized (set) {
            if (!this.scanners.remove(handler)) {
                return;
            }
            this.deviceCache.removeScanner(handler);
            this.updateScan();
        }
    }

    private void updateScan() {
        if (this.scanners.isEmpty()) {
            if (this.pendingConnections.isEmpty()) {
                this.bluetoothLeScanner.stopScan(this.scanCallback);
                this.scanCallback = null;
            }
            return;
        }
        if (this.scanCallback != null) {
            return;
        }
        ImmutableList scanFilters = ImmutableList.of((Object)new ScanFilter.Builder().setManufacturerData(1001, new byte[0], new byte[0]).build());
        ScanSettings scanSettings = new ScanSettings.Builder().setCallbackType(1).setScanMode(1).build();
        this.scanCallback = new ScanCallback((List)scanFilters, scanSettings){
            final /* synthetic */ List val$scanFilters;
            final /* synthetic */ ScanSettings val$scanSettings;
            {
                this.val$scanFilters = list;
                this.val$scanSettings = scanSettings;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onScanResult(int callbackType, ScanResult result) {
                ScanRecord record = result.getScanRecord();
                byte[] data = record.getManufacturerSpecificData(1001);
                ByteBuffer buffer = ByteBuffer.wrap(data);
                final long stamp = buffer.getLong();
                final String deviceId = result.getDevice().getAddress();
                if (BlePlugin.this.deviceCache.haveSeenStamp(stamp, deviceId)) {
                    return;
                }
                BluetoothGattReader.Handler handler = new BluetoothGattReader.Handler(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handle(Map<UUID, Map<UUID, byte[]>> services) {
                        if (services != null) {
                            ArrayList<AdInfo> adInfos = new ArrayList<AdInfo>();
                            for (Map.Entry<UUID, Map<UUID, byte[]>> entry : services.entrySet()) {
                                try {
                                    AdInfo adInfo = ConvertUtil.toAdInfo(entry.getValue());
                                    adInfos.add(adInfo);
                                }
                                catch (IOException e) {
                                    Log.e((String)BlePlugin.TAG, (String)("failed to convert advertisement" + e));
                                }
                            }
                            BlePlugin.this.deviceCache.saveDevice(stamp, deviceId, adInfos);
                        }
                        Set set = BlePlugin.this.scanners;
                        synchronized (set) {
                            BlePlugin.this.pendingConnections.remove(deviceId);
                            if (BlePlugin.this.pendingConnections.isEmpty()) {
                                if (BlePlugin.this.scanners.isEmpty()) {
                                    BlePlugin.this.scanCallback = null;
                                    return;
                                }
                                BlePlugin.this.bluetoothLeScanner.startScan(val$scanFilters, val$scanSettings, BlePlugin.this.scanCallback);
                            }
                        }
                    }
                };
                BluetoothGattReader cb = new BluetoothGattReader(handler);
                Set set = BlePlugin.this.scanners;
                synchronized (set) {
                    if (BlePlugin.this.scanners.isEmpty()) {
                        return;
                    }
                    if (!BlePlugin.this.pendingConnections.add(deviceId)) {
                        return;
                    }
                    if (BlePlugin.this.pendingConnections.size() == 1) {
                        BlePlugin.this.bluetoothLeScanner.stopScan(BlePlugin.this.scanCallback);
                    }
                }
                Log.d((String)BlePlugin.TAG, (String)("connecting to " + result.getDevice()));
                result.getDevice().connectGatt(BlePlugin.this.androidContext, false, (BluetoothGattCallback)cb);
            }

            public void onBatchScanResults(List<ScanResult> results) {
            }

            public void onScanFailed(int errorCode) {
            }
        };
        this.bluetoothLeScanner.startScan((List)scanFilters, scanSettings, this.scanCallback);
    }
}

