// Copyright 2016 The Vanadium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// This file was auto-generated by the vanadium vdl tool.

// Source(s):  beamer.vdl
package io.v.android.impl.google.services.beam;

/**
 * Wrapper for {@link IntentBeamerServer}.  This wrapper is used by
 * {@link io.v.v23.rpc.ReflectInvoker} to indirectly invoke server methods.
 */
public final class IntentBeamerServerWrapper {
  private final io.v.android.impl.google.services.beam.IntentBeamerServer server;

  /**
   * Creates a new {@link IntentBeamerServerWrapper} to invoke the methods of the
   * provided server.
   *
   * @param server server whose methods are to be invoked
   */
  public IntentBeamerServerWrapper(
      io.v.android.impl.google.services.beam.IntentBeamerServer server) {
    this.server = server;
  }

  /**
   * Returns a description of this server.
   */
  public io.v.v23.vdlroot.signature.Interface signature() {
    java.util.List<io.v.v23.vdlroot.signature.Embed> embeds =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Embed>();
    java.util.List<io.v.v23.vdlroot.signature.Method> methods =
        new java.util.ArrayList<io.v.v23.vdlroot.signature.Method>();

    {
      java.util.List<io.v.v23.vdlroot.signature.Arg> inArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      inArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      java.util.List<io.v.v23.vdlroot.signature.Arg> outArgs =
          new java.util.ArrayList<io.v.v23.vdlroot.signature.Arg>();

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg(
              "", "", new io.v.v23.vdl.VdlTypeObject(java.lang.String.class)));

      outArgs.add(
          new io.v.v23.vdlroot.signature.Arg("", "", new io.v.v23.vdl.VdlTypeObject(byte[].class)));

      java.util.List<io.v.v23.vdl.VdlAny> tags = new java.util.ArrayList<io.v.v23.vdl.VdlAny>();

      methods.add(
          new io.v.v23.vdlroot.signature.Method(
              "getIntent", "", inArgs, outArgs, null, null, tags));
    }

    return new io.v.v23.vdlroot.signature.Interface(
        "IntentBeamer", "io.v.android.impl.google.services.beam", "", embeds, methods);
  }

  /**
   * Returns all tags associated with the provided method or {@code null} if the method isn't
   * implemented by this server.
   *
   * @param method method whose tags are to be returned
   */
  @SuppressWarnings("unused")
  public io.v.v23.vdl.VdlValue[] getMethodTags(java.lang.String method)
      throws io.v.v23.verror.VException {

    if ("getIntent".equals(method)) {
      try {
        return new io.v.v23.vdl.VdlValue[] {};

      } catch (IllegalArgumentException e) {
        throw new io.v.v23.verror.VException(
            String.format("Couldn't get tags for method \"getIntent\": %s", e.getMessage()));
      }
    }

    return null; // method not found
  }

  public com.google.common.util.concurrent.ListenableFuture<
          io.v.android.impl.google.services.beam.IntentBeamerServer.GetIntentOut>
      getIntent(
          io.v.v23.context.VContext _ctx,
          final io.v.v23.rpc.StreamServerCall _call,
          final java.lang.String secret) {

    return this.server.getIntent(_ctx, _call, secret);
  }
}
