/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.UndertowMessages;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.DirectByteBufferDeallocator;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class DefaultByteBufferPool
implements ByteBufferPool {
    private final ThreadLocal<ThreadLocalData> threadLocalCache = new ThreadLocal();
    private final List<WeakReference<ThreadLocalData>> threadLocalDataList = new ArrayList<WeakReference<ThreadLocalData>>();
    private final ConcurrentLinkedQueue<ByteBuffer> queue = new ConcurrentLinkedQueue();
    private final boolean direct;
    private final int bufferSize;
    private final int maximumPoolSize;
    private final int threadLocalCacheSize;
    private final int leakDectionPercent;
    private int count;
    private volatile int currentQueueLength = 0;
    private static final AtomicIntegerFieldUpdater<DefaultByteBufferPool> currentQueueLengthUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultByteBufferPool.class, "currentQueueLength");
    private volatile int reclaimedThreadLocals = 0;
    private static final AtomicIntegerFieldUpdater<DefaultByteBufferPool> reclaimedThreadLocalsUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultByteBufferPool.class, "reclaimedThreadLocals");
    private volatile boolean closed;
    private final DefaultByteBufferPool arrayBackedPool;

    public DefaultByteBufferPool(boolean direct, int bufferSize) {
        this(direct, bufferSize, -1, 12, 0);
    }

    public DefaultByteBufferPool(boolean direct, int bufferSize, int maximumPoolSize, int threadLocalCacheSize, int leakDecetionPercent) {
        this.direct = direct;
        this.bufferSize = bufferSize;
        this.maximumPoolSize = maximumPoolSize;
        this.threadLocalCacheSize = threadLocalCacheSize;
        this.leakDectionPercent = leakDecetionPercent;
        this.arrayBackedPool = direct ? new DefaultByteBufferPool(false, bufferSize, maximumPoolSize, 0, leakDecetionPercent) : this;
    }

    public DefaultByteBufferPool(boolean direct, int bufferSize, int maximumPoolSize, int threadLocalCacheSize) {
        this(direct, bufferSize, maximumPoolSize, threadLocalCacheSize, 0);
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledByteBuffer allocate() {
        if (this.closed) {
            throw UndertowMessages.MESSAGES.poolIsClosed();
        }
        ByteBuffer buffer = null;
        ThreadLocalData local = null;
        if (this.threadLocalCacheSize > 0) {
            local = this.threadLocalCache.get();
            if (local != null) {
                buffer = local.buffers.poll();
            } else {
                local = new ThreadLocalData();
                List<WeakReference<ThreadLocalData>> list = this.threadLocalDataList;
                synchronized (list) {
                    if (this.closed) {
                        throw UndertowMessages.MESSAGES.poolIsClosed();
                    }
                    this.cleanupThreadLocalData();
                    this.threadLocalDataList.add(new WeakReference<ThreadLocalData>(local));
                    this.threadLocalCache.set(local);
                }
            }
        }
        if (buffer == null && (buffer = this.queue.poll()) != null) {
            currentQueueLengthUpdater.decrementAndGet(this);
        }
        if (buffer == null) {
            buffer = this.direct ? ByteBuffer.allocateDirect(this.bufferSize) : ByteBuffer.allocate(this.bufferSize);
        }
        if (local != null && local.allocationDepth < this.threadLocalCacheSize) {
            ++local.allocationDepth;
        }
        buffer.clear();
        return new DefaultPooledBuffer(this, buffer, this.leakDectionPercent == 0 ? false : ++this.count % 100 < this.leakDectionPercent);
    }

    @Override
    public ByteBufferPool getArrayBackedPool() {
        return this.arrayBackedPool;
    }

    private void cleanupThreadLocalData() {
        int size = this.threadLocalDataList.size();
        if (this.reclaimedThreadLocals > size / 4) {
            int i;
            int j = 0;
            for (i = 0; i < size; ++i) {
                WeakReference<ThreadLocalData> ref = this.threadLocalDataList.get(i);
                if (ref.get() == null) continue;
                this.threadLocalDataList.set(j++, ref);
            }
            for (i = size - 1; i >= j; --i) {
                this.threadLocalDataList.remove(i);
            }
            reclaimedThreadLocalsUpdater.addAndGet(this, -1 * (size - j));
        }
    }

    private void freeInternal(ByteBuffer buffer) {
        if (this.closed) {
            DirectByteBufferDeallocator.free(buffer);
            return;
        }
        ThreadLocalData local = this.threadLocalCache.get();
        if (local != null && local.allocationDepth > 0) {
            --local.allocationDepth;
            if (local.buffers.size() < this.threadLocalCacheSize) {
                local.buffers.add(buffer);
                return;
            }
        }
        this.queueIfUnderMax(buffer);
    }

    private void queueIfUnderMax(ByteBuffer buffer) {
        int size;
        do {
            if ((size = this.currentQueueLength) <= this.maximumPoolSize) continue;
            DirectByteBufferDeallocator.free(buffer);
            return;
        } while (!currentQueueLengthUpdater.compareAndSet(this, size, size + 1));
        this.queue.add(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.queue.clear();
        List<WeakReference<ThreadLocalData>> list = this.threadLocalDataList;
        synchronized (list) {
            for (WeakReference<ThreadLocalData> ref : this.threadLocalDataList) {
                ThreadLocalData local = (ThreadLocalData)ref.get();
                if (local != null) {
                    local.buffers.clear();
                }
                ref.clear();
            }
            this.threadLocalDataList.clear();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private static class LeakDetector {
        volatile boolean closed = false;
        private final Throwable allocationPoint = new Throwable("Buffer leak detected");

        private LeakDetector() {
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.allocationPoint.printStackTrace();
            }
        }
    }

    private class ThreadLocalData {
        ArrayDeque<ByteBuffer> buffers;
        int allocationDepth;

        private ThreadLocalData() {
            this.buffers = new ArrayDeque(DefaultByteBufferPool.this.threadLocalCacheSize);
            this.allocationDepth = 0;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            reclaimedThreadLocalsUpdater.incrementAndGet(DefaultByteBufferPool.this);
            if (this.buffers != null) {
                ByteBuffer buffer;
                while ((buffer = this.buffers.poll()) != null) {
                    DefaultByteBufferPool.this.queueIfUnderMax(buffer);
                }
            }
        }
    }

    private static class DefaultPooledBuffer
    implements PooledByteBuffer {
        private final DefaultByteBufferPool pool;
        private final LeakDetector leakDetector;
        private ByteBuffer buffer;
        private volatile int referenceCount = 1;
        private static final AtomicIntegerFieldUpdater<DefaultPooledBuffer> referenceCountUpdater = AtomicIntegerFieldUpdater.newUpdater(DefaultPooledBuffer.class, "referenceCount");

        DefaultPooledBuffer(DefaultByteBufferPool pool, ByteBuffer buffer, boolean detectLeaks) {
            this.pool = pool;
            this.buffer = buffer;
            this.leakDetector = detectLeaks ? new LeakDetector() : null;
        }

        @Override
        public ByteBuffer getBuffer() {
            ByteBuffer tmp = this.buffer;
            if (this.referenceCount == 0 || tmp == null) {
                throw UndertowMessages.MESSAGES.bufferAlreadyFreed();
            }
            return tmp;
        }

        @Override
        public void close() {
            ByteBuffer tmp = this.buffer;
            if (referenceCountUpdater.compareAndSet(this, 1, 0)) {
                this.buffer = null;
                if (this.leakDetector != null) {
                    this.leakDetector.closed = true;
                }
                this.pool.freeInternal(tmp);
            }
        }

        @Override
        public boolean isOpen() {
            return this.referenceCount > 0;
        }

        public String toString() {
            return "DefaultPooledBuffer{buffer=" + this.buffer + ", referenceCount=" + this.referenceCount + '}';
        }
    }
}

