/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.servlet.config;

import io.swagger.config.FilterFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import javax.servlet.ServletConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebXMLReader
implements SwaggerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebXMLReader.class);
    private final String filterClass;
    private final String apiVersion;
    private final String title;
    private String basePath;
    private String host;
    private Scheme scheme = Scheme.HTTP;

    public WebXMLReader(ServletConfig servletConfig) {
        String[] parts;
        this.apiVersion = WebXMLReader.getInitParameter(servletConfig, "api.version", "Swagger Server");
        this.basePath = WebXMLReader.getInitParameter(servletConfig, "swagger.api.basepath", null);
        this.title = WebXMLReader.getInitParameter(servletConfig, "swagger.api.title", "");
        this.filterClass = WebXMLReader.getInitParameter(servletConfig, "swagger.filter", null);
        if (this.basePath != null && (parts = this.basePath.split("://")).length > 1) {
            this.scheme = Scheme.forValue((String)parts[0]);
            int pos = parts[1].indexOf("/");
            if (pos >= 0) {
                this.basePath = parts[1].substring(pos);
                this.host = parts[1].substring(0, pos);
            } else {
                this.basePath = null;
                this.host = parts[1];
            }
        }
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter((SwaggerSpecFilter)filter);
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
    }

    private static String getInitParameter(ServletConfig servletConfig, String parameterName, String defaultValue) {
        String value = servletConfig.getInitParameter(parameterName);
        return StringUtils.isEmpty((CharSequence)value) ? defaultValue : value;
    }

    public Swagger configure(Swagger swagger) {
        Info info;
        if (swagger == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.basePath)) {
            swagger.basePath(this.basePath);
        }
        if (StringUtils.isNotBlank((CharSequence)this.host)) {
            swagger.host(this.host);
        }
        if (this.scheme != null) {
            swagger.scheme(this.scheme);
        }
        if ((info = swagger.getInfo()) == null) {
            info = new Info();
            swagger.info(info);
        }
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            info.title(this.title);
        }
        if (StringUtils.isNotBlank((CharSequence)this.apiVersion)) {
            info.version(this.apiVersion);
        }
        return swagger;
    }

    public String getFilterClass() {
        return this.filterClass;
    }
}

