/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.Xml;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.In;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.util.Json;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SwaggerDeserializer {
    protected static Set<String> ROOT_KEYS = new LinkedHashSet<String>(Arrays.asList("swagger", "info", "host", "basePath", "schemes", "consumes", "produces", "paths", "definitions", "parameters", "responses", "securityDefinitions", "security", "tags", "externalDocs"));
    protected static Set<String> EXTERNAL_DOCS_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "url"));
    protected static Set<String> SCHEMA_KEYS = new LinkedHashSet<String>(Arrays.asList("discriminator", "example", "$ref", "format", "title", "description", "default", "multipleOf", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "maxProperties", "minProperties", "required", "enum", "type", "items", "allOf", "properties", "additionalProperties", "xml", "readOnly", "allowEmptyValue"));
    protected static Set<String> INFO_KEYS = new LinkedHashSet<String>(Arrays.asList("title", "description", "termsOfService", "contact", "license", "version"));
    protected static Set<String> TAG_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "name", "externalDocs"));
    protected static Set<String> RESPONSE_KEYS = new LinkedHashSet<String>(Arrays.asList("description", "schema", "headers", "examples"));
    protected static Set<String> CONTACT_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url", "email"));
    protected static Set<String> LICENSE_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "url"));
    protected static Set<String> REF_MODEL_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref"));
    protected static Set<String> PATH_KEYS = new LinkedHashSet<String>(Arrays.asList("$ref", "get", "put", "post", "delete", "head", "patch", "options", "parameters"));
    protected static Set<String> OPERATION_KEYS = new LinkedHashSet<String>(Arrays.asList("scheme", "tags", "summary", "description", "externalDocs", "operationId", "consumes", "produces", "parameters", "responses", "schemes", "deprecated", "security"));
    protected static Set<String> PARAMETER_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "in", "description", "required", "type", "format", "allowEmptyValue", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf", "readOnly", "allowEmptyValue"));
    protected static Set<String> BODY_PARAMETER_KEYS = new LinkedHashSet<String>(Arrays.asList("name", "in", "description", "required", "schema"));
    protected static Set<String> SECURITY_SCHEME_KEYS = new LinkedHashSet<String>(Arrays.asList("type", "name", "in", "description", "flow", "authorizationUrl", "tokenUrl", "scopes"));

    public SwaggerDeserializationResult deserialize(JsonNode rootNode) {
        SwaggerDeserializationResult result = new SwaggerDeserializationResult();
        ParseResult rootParse = new ParseResult();
        Swagger swagger = this.parseRoot(rootNode, rootParse);
        result.setSwagger(swagger);
        result.setMessages(rootParse.getMessages());
        return result;
    }

    public Swagger parseRoot(JsonNode node, ParseResult result) {
        String location = "";
        Swagger swagger = new Swagger();
        if (node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            String s;
            ObjectNode on = (ObjectNode)node;
            Iterator it = null;
            String value = this.getString("swagger", on, true, location, result);
            swagger.setSwagger(value);
            ObjectNode obj = this.getObject("info", on, true, "", result);
            if (obj != null) {
                Info info = this.info(obj, "info", result);
                swagger.info(info);
            }
            value = this.getString("host", on, false, location, result);
            swagger.setHost(value);
            value = this.getString("basePath", on, false, location, result);
            swagger.setBasePath(value);
            ArrayNode array = this.getArray("schemes", on, false, location, result);
            if (array != null) {
                for (JsonNode n : array) {
                    Scheme scheme;
                    s = this.getString(n, location + ".schemes", result);
                    if (s == null || (scheme = Scheme.forValue((String)s)) == null) continue;
                    swagger.scheme(scheme);
                }
            }
            if ((array = this.getArray("consumes", on, false, location, result)) != null) {
                for (JsonNode n : array) {
                    s = this.getString(n, location + ".consumes", result);
                    if (s == null) continue;
                    swagger.consumes(s);
                }
            }
            if ((array = this.getArray("produces", on, false, location, result)) != null) {
                for (JsonNode n : array) {
                    s = this.getString(n, location + ".produces", result);
                    if (s == null) continue;
                    swagger.produces(s);
                }
            }
            obj = this.getObject("paths", on, true, location, result);
            Map<String, Path> paths = this.paths(obj, "paths", result);
            swagger.paths(paths);
            obj = this.getObject("definitions", on, false, location, result);
            Map<String, Model> definitions = this.definitions(obj, "definitions", result);
            swagger.setDefinitions(definitions);
            obj = this.getObject("parameters", on, false, location, result);
            if (obj != null) {
                LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
                Set<String> keys = this.getKeys(obj);
                for (String key : keys) {
                    JsonNode paramNode = obj.get(key);
                    if (!(paramNode instanceof ObjectNode)) continue;
                    Parameter parameter = this.parameter((ObjectNode)paramNode, location, result);
                    parameters.put(key, parameter);
                }
                swagger.setParameters(parameters);
            }
            obj = this.getObject("responses", on, false, location, result);
            Map<String, Response> responses = this.responses(obj, "responses", result);
            swagger.responses(responses);
            obj = this.getObject("securityDefinitions", on, false, location, result);
            Map<String, SecuritySchemeDefinition> securityDefinitions = this.securityDefinitions(obj, "securityDefinitions", result);
            swagger.setSecurityDefinitions(securityDefinitions);
            array = this.getArray("security", on, false, location, result);
            List<SecurityRequirement> security = this.securityRequirements(array, "security", result);
            swagger.setSecurity(security);
            array = this.getArray("tags", on, false, location, result);
            List<Tag> tags = this.tags(array, "tags", result);
            swagger.tags(tags);
            obj = this.getObject("externalDocs", on, false, location, result);
            ExternalDocs docs = this.externalDocs(obj, "externalDocs", result);
            swagger.externalDocs(docs);
            Set<String> keys = this.getKeys(on);
            for (String key : keys) {
                if (key.startsWith("x-")) {
                    swagger.vendorExtension(key, this.extension(on.get(key)));
                    continue;
                }
                if (ROOT_KEYS.contains(key)) continue;
                result.extra(location, key, node.get(key));
            }
        } else {
            result.invalidType("", "", "object", node);
            result.invalid();
            return null;
        }
        return swagger;
    }

    public Map<String, Path> paths(ObjectNode obj, String location, ParseResult result) {
        LinkedHashMap<String, Path> output = new LinkedHashMap<String, Path>();
        if (obj == null) {
            return null;
        }
        Set<String> pathKeys = this.getKeys(obj);
        for (String pathName : pathKeys) {
            JsonNode pathValue = obj.get(pathName);
            if (pathName.startsWith("x-")) {
                result.unsupported(location, pathName, pathValue);
                continue;
            }
            if (!pathValue.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                result.invalidType(location, pathName, "object", pathValue);
                continue;
            }
            ObjectNode path = (ObjectNode)pathValue;
            Path pathObj = this.path(path, location + ".'" + pathName + "'", result);
            output.put(pathName, pathObj);
        }
        return output;
    }

    public Path path(ObjectNode obj, String location, ParseResult result) {
        Operation op;
        boolean hasRef = false;
        Object output = null;
        if (obj.get("$ref") != null) {
            JsonNode ref = obj.get("$ref");
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                return this.pathRef((TextNode)ref, location, result);
            }
            if (ref.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode on = (ObjectNode)ref;
                Set<String> keys = this.getKeys(on);
                for (String key : keys) {
                    result.extra(location, key, on.get(key));
                }
            }
            return null;
        }
        Path path = new Path();
        ArrayNode parameters = this.getArray("parameters", obj, false, location, result);
        path.setParameters(this.parameters(parameters, location, result));
        ObjectNode on = this.getObject("get", obj, false, location, result);
        if (on != null && (op = this.operation(on, location + "(get)", result)) != null) {
            path.setGet(op);
        }
        if ((on = this.getObject("put", obj, false, location, result)) != null && (op = this.operation(on, location + "(put)", result)) != null) {
            path.setPut(op);
        }
        if ((on = this.getObject("post", obj, false, location, result)) != null && (op = this.operation(on, location + "(post)", result)) != null) {
            path.setPost(op);
        }
        if ((on = this.getObject("head", obj, false, location, result)) != null && (op = this.operation(on, location + "(head)", result)) != null) {
            path.setHead(op);
        }
        if ((on = this.getObject("delete", obj, false, location, result)) != null && (op = this.operation(on, location + "(delete)", result)) != null) {
            path.setDelete(op);
        }
        if ((on = this.getObject("patch", obj, false, location, result)) != null && (op = this.operation(on, location + "(patch)", result)) != null) {
            path.setPatch(op);
        }
        if ((on = this.getObject("options", obj, false, location, result)) != null && (op = this.operation(on, location + "(options)", result)) != null) {
            path.setOptions(op);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (key.startsWith("x-")) {
                path.setVendorExtension(key, this.extension(obj.get(key)));
                continue;
            }
            if (PATH_KEYS.contains(key)) continue;
            result.extra(location, key, obj.get(key));
        }
        return path;
    }

    public Operation operation(ObjectNode obj, String location, ParseResult result) {
        List<SecurityRequirement> security;
        Boolean deprecated;
        String s;
        if (obj == null) {
            return null;
        }
        Operation output = new Operation();
        ArrayNode array = this.getArray("tags", obj, false, location, result);
        List<String> tags = this.tagStrings(array, location, result);
        if (tags != null) {
            output.tags(tags);
        }
        String value = this.getString("summary", obj, false, location, result);
        output.summary(value);
        value = this.getString("description", obj, false, location, result);
        output.description(value);
        ObjectNode externalDocs = this.getObject("externalDocs", obj, false, location, result);
        ExternalDocs docs = this.externalDocs(externalDocs, location, result);
        output.setExternalDocs(docs);
        value = this.getString("operationId", obj, false, location, result);
        output.operationId(value);
        array = this.getArray("consumes", obj, false, location, result);
        if (array != null) {
            if (array.size() == 0) {
                output.consumes(Collections.emptyList());
            } else {
                for (JsonNode n : array) {
                    s = this.getString(n, location + ".consumes", result);
                    if (s == null) continue;
                    output.consumes(s);
                }
            }
        }
        if ((array = this.getArray("produces", obj, false, location, result)) != null) {
            if (array.size() == 0) {
                output.produces(Collections.emptyList());
            } else {
                for (JsonNode n : array) {
                    s = this.getString(n, location + ".produces", result);
                    if (s == null) continue;
                    output.produces(s);
                }
            }
        }
        ArrayNode parameters = this.getArray("parameters", obj, false, location, result);
        output.setParameters(this.parameters(parameters, location, result));
        ObjectNode responses = this.getObject("responses", obj, true, location, result);
        Map<String, Response> responsesObject = this.responses(responses, location, result);
        if (responsesObject != null && responsesObject.size() == 0) {
            result.missing(location, "responses");
        }
        output.setResponses(responsesObject);
        array = this.getArray("schemes", obj, false, location, result);
        if (array != null) {
            for (JsonNode n : array) {
                Scheme scheme;
                String s2 = this.getString(n, location + ".schemes", result);
                if (s2 == null || (scheme = Scheme.forValue((String)s2)) == null) continue;
                output.scheme(scheme);
            }
        }
        if ((deprecated = this.getBoolean("deprecated", obj, false, location, result)) != null) {
            output.setDeprecated(deprecated);
        }
        if ((security = this.securityRequirements(array = this.getArray("security", obj, false, location, result), location, result)) != null) {
            ArrayList<Map> ss = new ArrayList<Map>();
            for (SecurityRequirement s3 : security) {
                if (s3.getRequirements() == null || s3.getRequirements().size() <= 0) continue;
                ss.add(s3.getRequirements());
            }
            output.setSecurity(ss);
        }
        Set<String> keys = this.getKeys(obj);
        for (String key : keys) {
            if (key.startsWith("x-")) {
                output.setVendorExtension(key, this.extension(obj.get(key)));
                continue;
            }
            if (OPERATION_KEYS.contains(key)) continue;
            result.extra(location, key, obj.get(key));
        }
        return output;
    }

    public Boolean getBoolean(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Boolean value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.BOOLEAN)) {
            value = v.asBoolean();
        } else if (v.getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = v.textValue();
            return Boolean.parseBoolean(stringValue);
        }
        return value;
    }

    public List<Parameter> parameters(ArrayNode obj, String location, ParseResult result) {
        ArrayList<Parameter> output = new ArrayList<Parameter>();
        if (obj == null) {
            return output;
        }
        for (JsonNode item : obj) {
            Parameter param;
            if (!item.getNodeType().equals((Object)JsonNodeType.OBJECT) || (param = this.parameter((ObjectNode)item, location, result)) == null) continue;
            output.add(param);
        }
        return output;
    }

    public Parameter parameter(ObjectNode obj, String location, ParseResult result) {
        if (obj == null) {
            return null;
        }
        BodyParameter output = null;
        JsonNode ref = obj.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                return this.refParameter((TextNode)ref, location, result);
            }
            result.invalidType(location, "$ref", "string", (JsonNode)obj);
            return null;
        }
        String l = null;
        JsonNode ln = obj.get("name");
        l = ln != null ? ln.asText() : "['unknown']";
        String value = this.getString("in", obj, true, location = location + ".[" + l + "]", result);
        if (value != null) {
            String type = this.getString("type", obj, false, location, result);
            String format = this.getString("format", obj, false, location, result);
            QueryParameter sp = null;
            if ("query".equals(value)) {
                sp = new QueryParameter();
            } else if ("header".equals(value)) {
                sp = new HeaderParameter();
            } else if ("path".equals(value)) {
                sp = new PathParameter();
            } else if ("formData".equals(value)) {
                sp = new FormParameter();
            }
            if (sp != null) {
                Property prop;
                Boolean bl;
                this.getString("type", obj, true, location, result);
                LinkedHashMap<PropertyBuilder.PropertyId, Object> map = new LinkedHashMap<PropertyBuilder.PropertyId, Object>();
                map.put(PropertyBuilder.PropertyId.TYPE, type);
                map.put(PropertyBuilder.PropertyId.FORMAT, format);
                String defaultValue = this.getString("default", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.DEFAULT, defaultValue);
                sp.setDefault((Object)defaultValue);
                BigDecimal bd = this.getBigDecimal("maximum", obj, false, location, result);
                if (bd != null) {
                    map.put(PropertyBuilder.PropertyId.MAXIMUM, bd);
                    sp.setMaximum(bd);
                }
                if ((bl = this.getBoolean("exclusiveMaximum", obj, false, location, result)) != null) {
                    map.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, bl);
                    sp.setExclusiveMaximum(bl);
                }
                if ((bd = this.getBigDecimal("minimum", obj, false, location, result)) != null) {
                    map.put(PropertyBuilder.PropertyId.MINIMUM, bd);
                    sp.setMinimum(bd);
                }
                if ((bl = this.getBoolean("exclusiveMinimum", obj, false, location, result)) != null) {
                    map.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, bl);
                    sp.setExclusiveMinimum(bl);
                }
                Integer maxLength = this.getInteger("maxLength", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.MAX_LENGTH, maxLength);
                sp.setMaxLength(maxLength);
                Integer minLength = this.getInteger("minLength", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.MIN_LENGTH, minLength);
                sp.setMinLength(minLength);
                String pat = this.getString("pattern", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.PATTERN, pat);
                sp.setPattern(pat);
                Integer iv = this.getInteger("maxItems", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.MAX_ITEMS, iv);
                sp.setMaxItems(iv);
                iv = this.getInteger("minItems", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.MIN_ITEMS, iv);
                sp.setMinItems(iv);
                iv = this.getInteger("minLength", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.MIN_LENGTH, iv);
                sp.setMinLength(iv);
                iv = this.getInteger("maxLength", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.MAX_LENGTH, iv);
                sp.setMaxLength(iv);
                bd = this.getBigDecimal("multipleOf", obj, false, location, result);
                if (bd != null) {
                    map.put(PropertyBuilder.PropertyId.MULTIPLE_OF, bd);
                    sp.setMultipleOf((Number)bd.doubleValue());
                }
                Boolean uniqueItems = this.getBoolean("uniqueItems", obj, false, location, result);
                map.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, uniqueItems);
                sp.setUniqueItems(uniqueItems);
                ArrayNode an = this.getArray("enum", obj, false, location, result);
                if (an != null) {
                    ArrayList<String> _enum = new ArrayList<String>();
                    for (JsonNode n : an) {
                        if (n.isValueNode()) {
                            _enum.add(n.asText());
                            continue;
                        }
                        result.invalidType(location, "enum", "value", n);
                    }
                    sp.setEnum(_enum);
                    map.put(PropertyBuilder.PropertyId.ENUM, _enum);
                }
                if ((bl = this.getBoolean("readOnly", obj, false, location, result)) != null) {
                    map.put(PropertyBuilder.PropertyId.READ_ONLY, bl);
                    sp.setReadOnly(bl);
                }
                if ((bl = this.getBoolean("allowEmptyValue", obj, false, location, result)) != null) {
                    map.put(PropertyBuilder.PropertyId.ALLOW_EMPTY_VALUE, bl);
                    sp.setAllowEmptyValue(bl);
                }
                if ((prop = PropertyBuilder.build((String)type, (String)format, map)) != null) {
                    sp.setProperty(prop);
                    ObjectNode items = this.getObject("items", obj, false, location, result);
                    if (items != null) {
                        Property inner = this.schema(null, (JsonNode)items, location, result);
                        sp.setItems(inner);
                    }
                }
                Set<String> keys = this.getKeys(obj);
                for (String key : keys) {
                    if (key.startsWith("x-")) {
                        sp.setVendorExtension(key, this.extension(obj.get(key)));
                        continue;
                    }
                    if (PARAMETER_KEYS.contains(key)) continue;
                    result.extra(location, key, obj.get(key));
                }
                String collectionFormat = this.getString("collectionFormat", obj, false, location, result);
                sp.setCollectionFormat(collectionFormat);
                output = sp;
            } else if ("body".equals(value)) {
                Boolean bl;
                String pat;
                ObjectNode examplesNode;
                BodyParameter bp = new BodyParameter();
                JsonNode node = obj.get("schema");
                if (node != null && node instanceof ObjectNode) {
                    bp.setSchema(this.definition((ObjectNode)node, location, result));
                }
                if ((examplesNode = this.getObject("examples", obj, false, location, result)) != null) {
                    Map examples = (Map)Json.mapper().convertValue((Object)examplesNode, (JavaType)Json.mapper().getTypeFactory().constructMapType(Map.class, String.class, Object.class));
                    bp.setExamples(examples);
                }
                if ((pat = this.getString("pattern", obj, false, location, result)) != null) {
                    bp.setPattern(pat);
                }
                if ((bl = this.getBoolean("allowEmptyValue", obj, false, location, result)) != null) {
                    bp.setAllowEmptyValue(bl);
                }
                if ((bl = this.getBoolean("readOnly", obj, false, location, result)) != null) {
                    bp.setReadOnly(bl);
                }
                Set<String> keys = this.getKeys(obj);
                for (String key : keys) {
                    if (key.startsWith("x-")) {
                        bp.setVendorExtension(key, this.extension(obj.get(key)));
                        continue;
                    }
                    if (BODY_PARAMETER_KEYS.contains(key)) continue;
                    result.extra(location, key, obj.get(key));
                }
                output = bp;
            }
            if (output != null) {
                value = this.getString("name", obj, true, location, result);
                output.setName(value);
                value = this.getString("description", obj, false, location, result);
                output.setDescription(value);
                Boolean required = this.getBoolean("required", obj, false, location, result);
                if (required != null) {
                    output.setRequired(required.booleanValue());
                }
            }
        }
        return output;
    }

    private Property schema(Map<String, Object> schemaItems, JsonNode obj, String location, ParseResult result) {
        return (Property)Json.mapper().convertValue((Object)obj, Property.class);
    }

    public RefParameter refParameter(TextNode obj, String location, ParseResult result) {
        return new RefParameter(obj.asText());
    }

    public RefResponse refResponse(TextNode obj, String location, ParseResult result) {
        return new RefResponse(obj.asText());
    }

    public Path pathRef(TextNode ref, String location, ParseResult result) {
        RefPath output = new RefPath();
        output.set$ref(ref.textValue());
        return output;
    }

    public Map<String, Model> definitions(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        Set<String> schemas = this.getKeys(node);
        LinkedHashMap<String, Model> output = new LinkedHashMap<String, Model>();
        for (String schemaName : schemas) {
            JsonNode schema = node.get(schemaName);
            if (schema.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                Model model = this.definition((ObjectNode)schema, location + "." + schemaName, result);
                if (model == null) continue;
                output.put(schemaName, model);
                continue;
            }
            result.invalidType(location, schemaName, "object", schema);
        }
        return output;
    }

    public Model definition(ObjectNode node, String location, ParseResult result) {
        if (result == null) {
            result = new ParseResult();
        }
        if (node == null) {
            result.missing(location, "empty schema");
            return null;
        }
        if (node.get("$ref") != null) {
            return this.refModel(node, location, result);
        }
        if (node.get("allOf") != null) {
            return this.allOfModel(node, location, result);
        }
        ArrayModel model = null;
        String value = null;
        String type = this.getString("type", node, false, location, result);
        ModelImpl m = new ModelImpl();
        if ("array".equals(type)) {
            ArrayModel am = new ArrayModel();
            ObjectNode propertyNode = this.getObject("properties", node, false, location, result);
            Map<String, Property> properties = this.properties(propertyNode, location, result);
            am.setProperties(properties);
            ObjectNode itemsNode = this.getObject("items", node, false, location, result);
            Property items = this.property(itemsNode, location, result);
            if (items != null) {
                am.items(items);
            }
            Set<String> keys = this.getKeys(node);
            for (String key : keys) {
                if (!key.startsWith("x-")) continue;
                am.setVendorExtension(key, this.extension(node.get(key)));
            }
            model = am;
        } else {
            ArrayNode required;
            JsonNode xml;
            ArrayNode arrayNode;
            ModelImpl impl = new ModelImpl();
            impl.setType(type);
            JsonNode ap = node.get("additionalProperties");
            if (ap != null && ap.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                impl.setAdditionalProperties((Property)Json.mapper().convertValue((Object)ap, Property.class));
            }
            value = this.getString("default", node, false, location, result);
            impl.setDefaultValue(value);
            value = this.getString("format", node, false, location, result);
            impl.setFormat(value);
            value = this.getString("discriminator", node, false, location, result);
            impl.setDiscriminator(value);
            Boolean bp = this.getBoolean("uniqueItems", node, false, location, result);
            if (bp != null) {
                impl.setUniqueItems(bp);
            }
            if ((ap = node.get("enum")) != null && (arrayNode = this.getArray("enum", node, false, location, result)) != null) {
                for (JsonNode n : arrayNode) {
                    if (n.isValueNode()) {
                        impl._enum(n.asText());
                        continue;
                    }
                    result.invalidType(location, "enum", "value", n);
                }
            }
            if ((xml = node.get("xml")) != null) {
                impl.setXml((Xml)Json.mapper().convertValue((Object)xml, Xml.class));
            }
            ObjectNode externalDocs = this.getObject("externalDocs", node, false, location, result);
            ExternalDocs docs = this.externalDocs(externalDocs, location, result);
            impl.setExternalDocs(docs);
            ObjectNode properties = this.getObject("properties", node, false, location, result);
            if (properties != null) {
                Set<String> propertyNames = this.getKeys(properties);
                for (String propertyName : propertyNames) {
                    JsonNode propertyNode = properties.get(propertyName);
                    if (propertyNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                        ObjectNode on = (ObjectNode)propertyNode;
                        Property property = this.property(on, location, result);
                        impl.property(propertyName, property);
                        continue;
                    }
                    result.invalidType(location, "properties", "object", propertyNode);
                }
            }
            if ((required = this.getArray("required", node, false, location, result)) != null) {
                ArrayList<String> requiredProperties = new ArrayList<String>();
                for (JsonNode n : required) {
                    if (n.getNodeType().equals((Object)JsonNodeType.STRING)) {
                        requiredProperties.add(((TextNode)n).textValue());
                        continue;
                    }
                    result.invalidType(location, "required", "string", n);
                }
                if (requiredProperties.size() > 0) {
                    impl.setRequired(requiredProperties);
                }
            }
            Set<String> keys = this.getKeys(node);
            for (String key : keys) {
                if (key.startsWith("x-")) {
                    impl.setVendorExtension(key, this.extension(node.get(key)));
                    continue;
                }
                if (SCHEMA_KEYS.contains(key)) continue;
                result.extra(location, key, node.get(key));
            }
            if ("{ }".equals(Json.pretty((Object)impl))) {
                return null;
            }
            model = impl;
        }
        JsonNode exampleNode = node.get("example");
        if (exampleNode != null) {
            if (exampleNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode on = this.getObject("example", node, false, location, result);
                if (on != null) {
                    model.setExample((Object)on);
                }
            } else {
                model.setExample((Object)exampleNode.toString());
            }
        }
        if (model != null) {
            value = this.getString("description", node, false, location, result);
            model.setDescription(value);
            value = this.getString("title", node, false, location, result);
            model.setTitle(value);
        }
        return model;
    }

    public Object extension(JsonNode jsonNode) {
        return Json.mapper().convertValue((Object)jsonNode, Object.class);
    }

    public Model allOfModel(ObjectNode node, String location, ParseResult result) {
        JsonNode sub = node.get("$ref");
        JsonNode allOf = node.get("allOf");
        if (sub != null) {
            if (sub.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                return this.refModel((ObjectNode)sub, location, result);
            }
            result.invalidType(location, "$ref", "object", sub);
            return null;
        }
        if (allOf != null) {
            ComposedModel model = null;
            if (allOf.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
                model = new ComposedModel();
                int pos = 0;
                for (JsonNode part : allOf) {
                    if (part.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                        Model segment = this.definition((ObjectNode)part, location, result);
                        if (segment != null) {
                            model.getAllOf().add(segment);
                        }
                    } else {
                        result.invalidType(location, "allOf[" + pos + "]", "object", part);
                    }
                    ++pos;
                }
                Model child = null;
                ArrayList<RefModel> interfaces = new ArrayList<RefModel>();
                for (Model m : model.getAllOf()) {
                    if (m instanceof RefModel) {
                        interfaces.add((RefModel)m);
                        continue;
                    }
                    if (!(m instanceof ModelImpl)) continue;
                    child = m;
                }
                model.setInterfaces(interfaces);
                if (child != null) {
                    model.setChild(child);
                }
            } else {
                result.invalidType(location, "allOf", "array", allOf);
            }
            Set<String> keys = this.getKeys(node);
            for (String key : keys) {
                if (key.startsWith("x-")) {
                    model.setVendorExtension(key, this.extension(node.get(key)));
                    continue;
                }
                if (!SCHEMA_KEYS.contains(key)) {
                    result.extra(location, key, node.get(key));
                    continue;
                }
                String value = this.getString("title", node, false, location, result);
                model.setTitle(value);
                value = this.getString("description", node, false, location, result);
                model.setDescription(value);
            }
            return model;
        }
        return null;
    }

    public Map<String, Property> properties(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, Property> output = new LinkedHashMap<String, Property>();
        Set<String> keys = this.getKeys(node);
        for (String propertyName : keys) {
            JsonNode propertyNode = node.get(propertyName);
            if (propertyNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                Property property = this.property((ObjectNode)propertyNode, location, result);
                output.put(propertyName, property);
                continue;
            }
            result.invalidType(location, propertyName, "object", propertyNode);
        }
        return output;
    }

    public Property property(ObjectNode node, String location, ParseResult result) {
        String refString;
        JsonNode enumNode;
        if (node != null && node.get("type") == null && (enumNode = node.get("enum")) != null && enumNode.isArray()) {
            String type = this.inferTypeFromArray((ArrayNode)enumNode);
            node.put("type", type);
        }
        if (node.get("$ref") != null && node.get("$ref").isTextual() && (refString = node.get("$ref").textValue()).indexOf("/") == -1 && refString.indexOf(".") > 0) {
            refString = "./" + refString;
            node.put("$ref", refString);
        }
        return (Property)Json.mapper().convertValue((Object)node, Property.class);
    }

    public String inferTypeFromArray(ArrayNode an) {
        if (an.size() == 0) {
            return "string";
        }
        String type = null;
        for (int i = 0; i < an.size(); ++i) {
            JsonNode element = an.get(0);
            if (element.isBoolean()) {
                if (type == null) {
                    type = "boolean";
                    continue;
                }
                if ("boolean".equals(type)) continue;
                type = "string";
                continue;
            }
            if (element.isNumber()) {
                if (type == null) {
                    type = "number";
                    continue;
                }
                if ("number".equals(type)) continue;
                type = "string";
                continue;
            }
            type = "string";
        }
        return type;
    }

    public RefModel refModel(ObjectNode node, String location, ParseResult result) {
        RefModel output = new RefModel();
        if (!node.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            result.invalidType(location, "$ref", "object", (JsonNode)node);
            return null;
        }
        String refValue = ((TextNode)node.get("$ref")).textValue();
        output.set$ref(refValue);
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (REF_MODEL_KEYS.contains(key)) continue;
            result.extra(location, key, node.get(key));
        }
        return output;
    }

    public Map<String, Response> responses(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        TreeMap<String, Response> output = new TreeMap<String, Response>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (key.startsWith("x-")) continue;
            ObjectNode obj = this.getObject(key, node, false, location + ".responses", result);
            Response response = this.response(obj, location + "." + key, result);
            output.put(key, response);
        }
        return output;
    }

    public Response response(ObjectNode node, String location, ParseResult result) {
        ObjectNode examplesNode;
        ObjectNode headersNode;
        if (node == null) {
            return null;
        }
        Response output = new Response();
        JsonNode ref = node.get("$ref");
        if (ref != null) {
            if (ref.getNodeType().equals((Object)JsonNodeType.STRING)) {
                return this.refResponse((TextNode)ref, location, result);
            }
            result.invalidType(location, "$ref", "string", (JsonNode)node);
            return null;
        }
        String value = this.getString("description", node, true, location, result);
        output.description(value);
        ObjectNode schema = this.getObject("schema", node, false, location, result);
        if (schema != null) {
            output.schema((Property)Json.mapper().convertValue((Object)schema, Property.class));
        }
        if ((headersNode = this.getObject("headers", node, false, location, result)) != null) {
            Map headers = (Map)Json.mapper().convertValue((Object)headersNode, (JavaType)Json.mapper().getTypeFactory().constructMapType(Map.class, String.class, Property.class));
            output.headers(headers);
        }
        if ((examplesNode = this.getObject("examples", node, false, location, result)) != null) {
            Map examples = (Map)Json.mapper().convertValue((Object)examplesNode, (JavaType)Json.mapper().getTypeFactory().constructMapType(Map.class, String.class, Object.class));
            output.setExamples(examples);
        }
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (key.startsWith("x-")) {
                output.setVendorExtension(key, this.extension(node.get(key)));
                continue;
            }
            if (RESPONSE_KEYS.contains(key)) continue;
            result.extra(location, key, node.get(key));
        }
        return output;
    }

    public Info info(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        Info info = new Info();
        String value = this.getString("title", node, true, location, result);
        info.title(value);
        value = this.getString("description", node, false, location, result);
        info.description(value);
        value = this.getString("termsOfService", node, false, location, result);
        info.termsOfService(value);
        ObjectNode obj = this.getObject("contact", node, false, "contact", result);
        Contact contact = this.contact(obj, location, result);
        info.contact(contact);
        obj = this.getObject("license", node, false, location, result);
        License license = this.license(obj, location, result);
        info.license(license);
        value = this.getString("version", node, false, location, result);
        info.version(value);
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (key.startsWith("x-")) {
                info.setVendorExtension(key, this.extension(node.get(key)));
                continue;
            }
            if (INFO_KEYS.contains(key)) continue;
            result.extra(location, key, node.get(key));
        }
        return info;
    }

    public License license(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        License license = new License();
        String value = this.getString("name", node, true, location, result);
        license.name(value);
        value = this.getString("url", node, false, location, result);
        license.url(value);
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (key.startsWith("x-")) {
                license.setVendorExtension(key, this.extension(node.get(key)));
                continue;
            }
            if (LICENSE_KEYS.contains(key)) continue;
            result.extra(location + ".license", key, node.get(key));
        }
        return license;
    }

    public Contact contact(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        Contact contact = new Contact();
        String value = this.getString("name", node, false, location + ".name", result);
        contact.name(value);
        value = this.getString("url", node, false, location + ".url", result);
        contact.url(value);
        value = this.getString("email", node, false, location + ".email", result);
        contact.email(value);
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            if (CONTACT_KEYS.contains(key)) continue;
            result.extra(location + ".contact", key, node.get(key));
        }
        return contact;
    }

    public Map<String, SecuritySchemeDefinition> securityDefinitions(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        LinkedHashMap<String, SecuritySchemeDefinition> output = new LinkedHashMap<String, SecuritySchemeDefinition>();
        Set<String> keys = this.getKeys(node);
        for (String key : keys) {
            ObjectNode obj = this.getObject(key, node, false, location, result);
            SecuritySchemeDefinition def = this.securityDefinition(obj, location + "." + key, result);
            if (def == null) continue;
            output.put(key, def);
        }
        return output;
    }

    public SecuritySchemeDefinition securityDefinition(ObjectNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        SecuritySchemeDefinition output = null;
        String type = this.getString("type", node, true, location, result);
        if (type != null) {
            if (type.equals("basic")) {
                output = (SecuritySchemeDefinition)Json.mapper().convertValue((Object)node, BasicAuthDefinition.class);
            } else if (type.equals("apiKey")) {
                JsonNode desc;
                In in;
                String position = this.getString("in", node, true, location, result);
                String name = this.getString("name", node, true, location, result);
                if (name != null && ("header".equals(position) || "query".equals(position)) && (in = In.forValue((String)position)) != null) {
                    output = new ApiKeyAuthDefinition().name(name).in(in);
                    String description = this.getString("description", node, false, location, result);
                    output.setDescription(description);
                }
                if ((desc = node.get("description")) != null) {
                    output.setDescription(desc.textValue());
                }
            } else if (type.equals("oauth2")) {
                output = (SecuritySchemeDefinition)Json.mapper().convertValue((Object)node, OAuth2Definition.class);
                JsonNode desc = node.get("description");
                if (desc != null) {
                    output.setDescription(desc.textValue());
                }
            } else {
                result.invalidType(location + ".type", "type", "basic|apiKey|oauth2", (JsonNode)node);
            }
            Set<String> keys = this.getKeys(node);
            for (String key : keys) {
                if (key.startsWith("x-")) {
                    output.setVendorExtension(key, this.extension(node.get(key)));
                    continue;
                }
                if (SECURITY_SCHEME_KEYS.contains(key)) continue;
                result.extra(location, key, node.get(key));
            }
        }
        return output;
    }

    public List<SecurityRequirement> securityRequirements(ArrayNode node, String location, ParseResult result) {
        if (node == null) {
            return null;
        }
        ArrayList<SecurityRequirement> output = new ArrayList<SecurityRequirement>();
        for (JsonNode item : node) {
            SecurityRequirement security = new SecurityRequirement();
            if (item.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                ObjectNode on = (ObjectNode)item;
                Set<String> keys = this.getKeys(on);
                for (String key : keys) {
                    ArrayList<String> scopes = new ArrayList<String>();
                    ArrayNode obj = this.getArray(key, on, false, location + ".security", result);
                    if (obj != null) {
                        for (JsonNode n : obj) {
                            if (n.getNodeType().equals((Object)JsonNodeType.STRING)) {
                                scopes.add(n.asText());
                                continue;
                            }
                            result.invalidType(location, key, "string", n);
                        }
                    }
                    security.requirement(key, scopes);
                }
            }
            output.add(security);
        }
        return output;
    }

    public List<String> tagStrings(ArrayNode nodes, String location, ParseResult result) {
        if (nodes == null) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        for (JsonNode node : nodes) {
            if (!node.getNodeType().equals((Object)JsonNodeType.STRING)) continue;
            output.add(node.textValue());
        }
        return output;
    }

    public List<Tag> tags(ArrayNode nodes, String location, ParseResult result) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Tag> output = new ArrayList<Tag>();
        for (JsonNode node : nodes) {
            Tag tag;
            if (!node.getNodeType().equals((Object)JsonNodeType.OBJECT) || (tag = this.tag((ObjectNode)node, location + ".tags", result)) == null) continue;
            output.add(tag);
        }
        return output;
    }

    public Tag tag(ObjectNode node, String location, ParseResult result) {
        Tag tag = null;
        if (node != null) {
            tag = new Tag();
            Set<String> keys = this.getKeys(node);
            String value = this.getString("name", node, true, location, result);
            tag.name(value);
            value = this.getString("description", node, false, location, result);
            tag.description(value);
            ObjectNode externalDocs = this.getObject("externalDocs", node, false, location, result);
            ExternalDocs docs = this.externalDocs(externalDocs, location + "externalDocs", result);
            tag.externalDocs(docs);
            for (String key : keys) {
                if (key.startsWith("x-")) {
                    tag.setVendorExtension(key, this.extension(node.get(key)));
                    continue;
                }
                if (TAG_KEYS.contains(key)) continue;
                result.extra(location + ".externalDocs", key, node.get(key));
            }
        }
        return tag;
    }

    public ExternalDocs externalDocs(ObjectNode node, String location, ParseResult result) {
        ExternalDocs output = null;
        if (node != null) {
            output = new ExternalDocs();
            Set<String> keys = this.getKeys(node);
            String value = this.getString("description", node, false, location, result);
            output.description(value);
            value = this.getString("url", node, true, location, result);
            output.url(value);
            for (String key : keys) {
                if (key.startsWith("x-")) {
                    output.setVendorExtension(key, this.extension(node.get(key)));
                    continue;
                }
                if (EXTERNAL_DOCS_KEYS.contains(key)) continue;
                result.extra(location + ".externalDocs", key, node.get(key));
            }
        }
        return output;
    }

    public String getString(JsonNode node, String location, ParseResult result) {
        String output = null;
        if (!node.getNodeType().equals((Object)JsonNodeType.STRING)) {
            result.invalidType(location, "", "string", node);
        } else {
            output = ((TextNode)node).asText();
        }
        return output;
    }

    public ArrayNode getArray(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        JsonNode value = node.get(key);
        ArrayNode an = null;
        if (value == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!value.getNodeType().equals((Object)JsonNodeType.ARRAY)) {
            result.invalidType(location, key, "array", value);
        } else {
            an = (ArrayNode)value;
        }
        return an;
    }

    public ObjectNode getObject(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        JsonNode value = node.get(key);
        ObjectNode on = null;
        if (value == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!value.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            result.invalidType(location, key, "object", value);
            if (required) {
                result.invalid();
            }
        } else {
            on = (ObjectNode)value;
        }
        return on;
    }

    public BigDecimal getBigDecimal(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        BigDecimal value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value = new BigDecimal(v.asText());
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "double", (JsonNode)node);
        }
        return value;
    }

    public Number getNumber(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Number value = null;
        JsonNode v = node.get(key);
        if (v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value = v.numberValue();
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "number", (JsonNode)node);
        }
        return value;
    }

    public Integer getInteger(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        Integer value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (v.getNodeType().equals((Object)JsonNodeType.NUMBER)) {
            value = v.intValue();
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "integer", (JsonNode)node);
        }
        return value;
    }

    public String getString(String key, ObjectNode node, boolean required, String location, ParseResult result) {
        String value = null;
        JsonNode v = node.get(key);
        if (node == null || v == null) {
            if (required) {
                result.missing(location, key);
                result.invalid();
            }
        } else if (!v.isValueNode()) {
            result.invalidType(location, key, "string", (JsonNode)node);
        } else {
            value = v.asText();
        }
        return value;
    }

    public Set<String> getKeys(ObjectNode node) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        if (node == null) {
            return keys;
        }
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            keys.add((String)it.next());
        }
        return keys;
    }

    protected static class Location {
        private String location;
        private String key;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Location)) {
                return false;
            }
            Location location1 = (Location)o;
            if (this.location != null ? !this.location.equals(location1.location) : location1.location != null) {
                return false;
            }
            return !(this.key == null ? location1.key != null : !this.key.equals(location1.key));
        }

        public int hashCode() {
            int result = this.location != null ? this.location.hashCode() : 0;
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public Location(String location, String key) {
            this.location = location;
            this.key = key;
        }
    }

    protected static class ParseResult {
        private boolean valid = true;
        private Map<Location, JsonNode> extra = new LinkedHashMap<Location, JsonNode>();
        private Map<Location, JsonNode> unsupported = new LinkedHashMap<Location, JsonNode>();
        private Map<Location, String> invalidType = new LinkedHashMap<Location, String>();
        private List<Location> missing = new ArrayList<Location>();

        public void unsupported(String location, String key, JsonNode value) {
            this.unsupported.put(new Location(location, key), value);
        }

        public void extra(String location, String key, JsonNode value) {
            this.extra.put(new Location(location, key), value);
        }

        public void missing(String location, String key) {
            this.missing.add(new Location(location, key));
        }

        public void invalidType(String location, String key, String expectedType, JsonNode value) {
            this.invalidType.put(new Location(location, key), expectedType);
        }

        public void invalid() {
            this.valid = false;
        }

        public Map<Location, JsonNode> getUnsupported() {
            return this.unsupported;
        }

        public void setUnsupported(Map<Location, JsonNode> unsupported) {
            this.unsupported = unsupported;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public Map<Location, JsonNode> getExtra() {
            return this.extra;
        }

        public void setExtra(Map<Location, JsonNode> extra) {
            this.extra = extra;
        }

        public Map<Location, String> getInvalidType() {
            return this.invalidType;
        }

        public void setInvalidType(Map<Location, String> invalidType) {
            this.invalidType = invalidType;
        }

        public List<Location> getMissing() {
            return this.missing;
        }

        public void setMissing(List<Location> missing) {
            this.missing = missing;
        }

        public List<String> getMessages() {
            String message;
            String location;
            ArrayList<String> messages = new ArrayList<String>();
            for (Location l : this.extra.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unexpected";
                messages.add(message);
            }
            for (Location l : this.invalidType.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is not of type `" + this.invalidType.get(l) + "`";
                messages.add(message);
            }
            for (Location l : this.missing) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is missing";
                messages.add(message);
            }
            for (Location l : this.unsupported.keySet()) {
                location = l.location.equals("") ? "" : l.location + ".";
                message = "attribute " + location + l.key + " is unsupported";
                messages.add(message);
            }
            return messages;
        }
    }
}

