/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.models.properties;

import io.swagger.models.Xml;
import io.swagger.models.properties.DecimalProperty;

public class FloatProperty
extends DecimalProperty {
    private static final String FORMAT = "float";
    protected Float _default;

    public FloatProperty() {
        super(FORMAT);
    }

    public static boolean isType(String type, String format) {
        return "number".equals(type) && FORMAT.equals(format);
    }

    @Override
    public FloatProperty xml(Xml xml) {
        this.setXml(xml);
        return this;
    }

    public FloatProperty example(Float example) {
        this.setExample(String.valueOf(example));
        return this;
    }

    public FloatProperty _default(String _default) {
        if (_default != null) {
            try {
                this._default = Float.valueOf(Float.parseFloat(_default));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this;
    }

    public FloatProperty _default(Float _default) {
        this.setDefault(_default);
        return this;
    }

    public Float getDefault() {
        return this._default;
    }

    @Override
    public void setDefault(String _default) {
        this._default(_default);
    }

    public void setDefault(Float _default) {
        this._default = _default;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._default == null ? 0 : this._default.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FloatProperty)) {
            return false;
        }
        FloatProperty other = (FloatProperty)obj;
        return !(this._default == null ? other._default != null : !this._default.equals(other._default));
    }
}

