/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDeserializer
extends JsonDeserializer<Property> {
    Logger LOGGER = LoggerFactory.getLogger(PropertyDeserializer.class);

    private static String getString(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : detailNode.asText();
    }

    private static Integer getInteger(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Integer.valueOf(detailNode.intValue());
    }

    private static Double getDouble(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Double.valueOf(detailNode.doubleValue());
    }

    private static Boolean getBoolean(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Boolean.valueOf(detailNode.booleanValue());
    }

    private static List<String> getEnum(JsonNode node, PropertyBuilder.PropertyId type) {
        ArrayList<String> result = new ArrayList<String>();
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        if (detailNode != null) {
            ArrayNode an = (ArrayNode)detailNode;
            for (JsonNode child : an) {
                if (!(child instanceof TextNode)) continue;
                result.add(child.asText());
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static JsonNode getDetailNode(JsonNode node, PropertyBuilder.PropertyId type) {
        return node.get(type.getPropertyName());
    }

    public Property deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return this.propertyFromNode(node);
    }

    Property propertyFromNode(JsonNode node) {
        Property items;
        String type = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TYPE);
        String format = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.FORMAT);
        String description = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIPTION);
        JsonNode detailNode = node.get("$ref");
        if (detailNode != null) {
            return new RefProperty(detailNode.asText()).description(description);
        }
        if (ObjectProperty.isType((String)type) && (detailNode = node.get("additionalProperties")) != null && (items = this.propertyFromNode(detailNode)) != null) {
            return new MapProperty(items).description(description);
        }
        if (ArrayProperty.isType((String)type) && (detailNode = node.get("items")) != null) {
            Property subProperty = this.propertyFromNode(detailNode);
            return new ArrayProperty().items(subProperty).description(description);
        }
        EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args.put(PropertyBuilder.PropertyId.TYPE, (Object)type);
        args.put(PropertyBuilder.PropertyId.FORMAT, (Object)format);
        args.put(PropertyBuilder.PropertyId.DESCRIPTION, (Object)description);
        args.put(PropertyBuilder.PropertyId.EXAMPLE, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.EXAMPLE));
        args.put(PropertyBuilder.PropertyId.ENUM, (Object)PropertyDeserializer.getEnum(node, PropertyBuilder.PropertyId.ENUM));
        args.put(PropertyBuilder.PropertyId.TITLE, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TITLE));
        args.put(PropertyBuilder.PropertyId.DEFAULT, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DEFAULT));
        args.put(PropertyBuilder.PropertyId.PATTERN, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.PATTERN));
        args.put(PropertyBuilder.PropertyId.DESCRIMINATOR, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIMINATOR));
        args.put(PropertyBuilder.PropertyId.MIN_ITEMS, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_ITEMS));
        args.put(PropertyBuilder.PropertyId.MAX_ITEMS, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_ITEMS));
        args.put(PropertyBuilder.PropertyId.MIN_PROPERTIES, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_PROPERTIES));
        args.put(PropertyBuilder.PropertyId.MAX_PROPERTIES, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_PROPERTIES));
        args.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_LENGTH));
        args.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_LENGTH));
        args.put(PropertyBuilder.PropertyId.MINIMUM, (Object)PropertyDeserializer.getDouble(node, PropertyBuilder.PropertyId.MINIMUM));
        args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)PropertyDeserializer.getDouble(node, PropertyBuilder.PropertyId.MAXIMUM));
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM));
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM));
        args.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.UNIQUE_ITEMS));
        Property output = PropertyBuilder.build((String)type, (String)format, args);
        if (output == null) {
            this.LOGGER.warn("no property from " + type + ", " + format + ", " + args);
            return null;
        }
        output.setDescription(description);
        return output;
    }
}

