/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.codegen.utils.Markdown;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StaticHtml2Generator
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String phpInvokerPackage = "Swagger\\Client";
    protected String packageName = "IO.Swagger";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";
    protected String jsProjectName;
    protected String jsModuleName;
    protected String perlModuleName = "WWW::SwaggerClient";
    protected String pythonPackageName = "swagger_client";

    public StaticHtml2Generator() {
        this.outputFolder = "docs";
        this.templateDir = "htmlDocs2";
        this.embeddedTemplateDir = "htmlDocs2";
        this.defaultIncludes = new HashSet();
        this.cliOptions.add(new CliOption("appName", "short name of the application"));
        this.cliOptions.add(new CliOption("appDescription", "description of the application"));
        this.cliOptions.add(new CliOption("infoUrl", "a URL where users can get more information about the application"));
        this.cliOptions.add(new CliOption("infoEmail", "an email address to contact for inquiries about the application"));
        this.cliOptions.add(new CliOption("licenseInfo", "a short description of the license"));
        this.cliOptions.add(new CliOption("licenseUrl", "a URL pointing to the full license"));
        this.cliOptions.add(new CliOption("invokerPackage", "root package for generated code"));
        this.cliOptions.add(new CliOption("phpInvokerPackage", "root package for generated php code"));
        this.cliOptions.add(new CliOption("perlModuleName", "root module name for generated perl code"));
        this.cliOptions.add(new CliOption("pythonPackageName", "package name for generated python code"));
        this.cliOptions.add(new CliOption("packageName", "C# package name"));
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml"));
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appDescription", "A sample swagger server");
        this.additionalProperties.put("infoUrl", "https://helloreverb.com");
        this.additionalProperties.put("infoEmail", "hello@helloreverb.com");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("phpInvokerPackage", this.phpInvokerPackage);
        this.additionalProperties.put("perlModuleName", this.perlModuleName);
        this.additionalProperties.put("pythonPackageName", this.pythonPackageName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.html"));
        this.reservedWords = new HashSet();
        this.languageSpecificPrimitives = new HashSet();
        this.importMapping = new HashMap();
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "html2";
    }

    @Override
    public String escapeText(String input) {
        return input;
    }

    @Override
    public String getHelp() {
        return "Generates a static HTML file.";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            Schema inner = ((ArraySchema)propertySchema).getItems();
            return String.format("%s[%s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        if (propertySchema instanceof MapSchema && StaticHtml2Generator.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return String.format("%s[String, %s]", this.getSchemaType(propertySchema), this.getTypeDeclaration(inner));
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase();
            for (CodegenResponse response : op.responses) {
                if (!"0".equals(response.code)) continue;
                response.code = "default";
            }
            op.formParams = this.postProcessParameterEnum(op.formParams);
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (StringUtils.isBlank((CharSequence)this.jsProjectName) && info.getTitle() != null) {
                this.jsProjectName = this.sanitizeName(this.dashize(info.getTitle()));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.jsProjectName)) {
            this.jsProjectName = "swagger-js-client";
        }
        if (StringUtils.isBlank((CharSequence)this.jsModuleName)) {
            this.jsModuleName = StaticHtml2Generator.camelize(StaticHtml2Generator.underscore(this.jsProjectName));
        }
        this.additionalProperties.put("jsProjectName", this.jsProjectName);
        this.additionalProperties.put("jsModuleName", this.jsModuleName);
        this.preparHtmlForGlobalDescription(openAPI);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI ope) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, definitions, ope);
        if (op.returnType != null) {
            op.returnType = this.normalizeType(op.returnType);
        }
        op.path = this.sanitizePath(op.path);
        CodegenParameter lastRequired = null;
        CodegenParameter lastOptional = null;
        for (CodegenParameter p : op.allParams) {
            if (p.required) {
                lastRequired = p;
                continue;
            }
            lastOptional = p;
        }
        for (CodegenParameter p : op.allParams) {
            if (p == lastRequired) {
                p.vendorExtensions.put("x-codegen-hasMoreRequired", false);
                continue;
            }
            if (p == lastOptional) {
                p.vendorExtensions.put("x-codegen-hasMoreOptional", false);
                continue;
            }
            p.vendorExtensions.put("x-codegen-hasMoreRequired", true);
            p.vendorExtensions.put("x-codegen-hasMoreOptional", true);
        }
        op.vendorExtensions.put("x-codegen-hasRequiredParams", lastRequired != null);
        op.vendorExtensions.put("x-codegen-httpMethodUpperCase", httpMethod.toUpperCase());
        return op;
    }

    private void preparHtmlForGlobalDescription(OpenAPI openAPI) {
        String currentDescription = openAPI.getInfo().getDescription();
        if (currentDescription != null && !currentDescription.isEmpty()) {
            Markdown markInstance = new Markdown();
            openAPI.getInfo().setDescription(markInstance.toHtml(currentDescription));
        } else {
            LOGGER.error("Swagger object description is empty [" + openAPI.getInfo().getTitle() + "]");
        }
    }

    public List<CodegenParameter> postProcessParameterEnum(List<CodegenParameter> parameterList) {
        String enumFormatted = "";
        for (CodegenParameter parameter : parameterList) {
            if (!ExtensionHelper.getBooleanValue(parameter, "x-is-enum")) continue;
            for (int i = 0; i < parameter._enum.size(); ++i) {
                String spacer;
                String string = spacer = i == parameter._enum.size() - 1 ? " " : ", ";
                if (parameter._enum.get(i) == null) continue;
                enumFormatted = enumFormatted + "`" + parameter._enum.get(i) + "`" + spacer;
            }
            Markdown markInstance = new Markdown();
            if (enumFormatted.isEmpty()) continue;
            parameter.vendorExtensions.put("x-eumFormatted", markInstance.toHtml(enumFormatted));
        }
        return parameterList;
    }

    private String sanitizePath(String p) {
        return p.replaceAll("'", "%27");
    }

    public String normalizeType(String type) {
        return type.replaceAll("\\b(Boolean|Integer|Number|String|Date)\\b", "'$1'");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

