/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractAdaCodegen;
import io.swagger.codegen.languages.helpers.ExtensionHelper;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class AdaCodegen
extends AbstractAdaCodegen
implements CodegenConfig {
    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ada";
    }

    @Override
    public String getHelp() {
        return "Generates an Ada client implementation (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.packageName = (String)this.additionalProperties.get("packageName");
        }
        if (this.packageName == "") {
            this.packageName = this.modelPackage;
        }
        String srcPrefix = "src" + File.separator;
        String modelPrefix = srcPrefix + "model" + File.separator + this.toFilename(this.modelPackage);
        String clientPrefix = srcPrefix + "client" + File.separator + this.toFilename(this.modelPackage);
        this.supportingFiles.add(new SupportingFile("model-spec.mustache", null, modelPrefix + "-models.ads"));
        this.supportingFiles.add(new SupportingFile("model-body.mustache", null, modelPrefix + "-models.adb"));
        this.supportingFiles.add(new SupportingFile("client-spec.mustache", null, clientPrefix + "-clients.ads"));
        this.supportingFiles.add(new SupportingFile("client-body.mustache", null, clientPrefix + "-clients.adb"));
        this.projectName = this.additionalProperties.containsKey("projectName") ? (String)this.additionalProperties.get("projectName") : this.packageName.replaceAll("\\.", "_");
        String configBaseName = this.modelPackage.toLowerCase();
        this.supportingFiles.add(new SupportingFile("gnat-project.mustache", "", this.toFilename(this.projectName) + ".gpr"));
        this.supportingFiles.add(new SupportingFile("config.gpr", "", "config.gpr"));
        this.additionalProperties.put("package", this.modelPackage);
        this.additionalProperties.put("packageConfig", configBaseName);
        this.additionalProperties.put("packageDir", "client");
        this.additionalProperties.put("mainName", "client");
        this.additionalProperties.put("projectName", this.projectName);
        String[] names = this.modelPackage.split("\\.");
        String pkgName = names[0];
        this.additionalProperties.put("packageLevel1", pkgName);
        this.supportingFiles.add(new SupportingFile("package-spec-level1.mustache", null, "src" + File.separator + this.toFilename(names[0]) + ".ads"));
        if (names.length > 1) {
            String fileName = this.toFilename(names[0]) + "-" + this.toFilename(names[1]) + ".ads";
            pkgName = names[0] + "." + names[1];
            this.additionalProperties.put("packageLevel2", pkgName);
            this.supportingFiles.add(new SupportingFile("package-spec-level2.mustache", null, "src" + File.separator + fileName));
        }
        pkgName = this.modelPackage;
        this.supportingFiles.add(new SupportingFile("client.mustache", null, "src" + File.separator + this.toFilename(pkgName) + "-client.adb"));
        this.additionalProperties.put("packageName", this.toFilename(pkgName));
        this.additionalProperties.put("lambdaAdaComment", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                String content = fragment.execute();
                content = content.trim().replaceAll("\n$", "");
                writer.write(content.replaceAll("\n", "\n   --  "));
            }
        });
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/model/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String escapeReservedWord(String name) {
        return "p_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        String swaggerType = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            return String.format("%s_Vectors.Vector", this.getTypeDeclaration(arraySchema.getItems()));
        }
        if (propertySchema instanceof MapSchema && AdaCodegen.hasSchemaProperties(propertySchema)) {
            return String.format("Swagger._Map", this.getTypeDeclaration((Schema)propertySchema.getAdditionalProperties()));
        }
        if (this.typeMapping.containsKey(swaggerType)) {
            return (String)this.typeMapping.get(swaggerType);
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return swaggerType;
        }
        String modelType = this.toModelName(swaggerType);
        if (propertySchema instanceof StringSchema || propertySchema instanceof DateSchema || propertySchema instanceof DateTimeSchema || propertySchema instanceof FileSchema || this.languageSpecificPrimitives.contains(modelType)) {
            return modelType;
        }
        return this.modelPackage + ".Models." + modelType;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        boolean isModel = parameter.dataType.startsWith(this.modelPackage);
        boolean isPrimitiveType = ExtensionHelper.getBooleanValue(parameter, "x-is-primitive-type");
        boolean isDate = ExtensionHelper.getBooleanValue(parameter, "x-is-date-time");
        boolean isString = ExtensionHelper.getBooleanValue(parameter, "x-is-string");
        boolean isContainer = ExtensionHelper.getBooleanValue(parameter, "x-is-container");
        boolean isFile = ExtensionHelper.getBooleanValue(parameter, "x-is-file");
        if (!(isModel || isPrimitiveType || isDate || isString || isContainer || isFile)) {
            isModel = true;
        }
        parameter.vendorExtensions.put("x-is-model-type", isModel);
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> definitions, OpenAPI openAPI) {
        MediaType mediaType;
        ApiResponse response;
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, definitions, openAPI);
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (response = this.findMethodResponse(operation.getResponses())) != null && response.getContent() != null && !response.getContent().isEmpty() && (mediaType = (MediaType)new ArrayList(response.getContent().values()).get(0)).getSchema() != null) {
            CodegenProperty cm = this.fromProperty("response", mediaType.getSchema());
            codegenOperation.vendorExtensions.put("x-codegen-response", cm);
            if (cm.datatype == "HttpContent") {
                codegenOperation.vendorExtensions.put("x-codegen-response-ishttpcontent", true);
            }
        }
        return codegenOperation;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op1 : operationList) {
            op1.vendorExtensions.put("x-has-uniq-produces", this.postProcessMediaTypes(op1.produces) == 1);
            op1.vendorExtensions.put("x-has-uniq-consumes", this.postProcessMediaTypes(op1.consumes) == 1);
            op1.vendorExtensions.put("x-has-notes", op1.notes.length() > 0);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Map model : models) {
            Object v = model.get("model");
            if (!(v instanceof CodegenModel)) continue;
            CodegenModel m = (CodegenModel)v;
            ArrayList<String> d = new ArrayList<String>();
            for (CodegenProperty p : m.allVars) {
                boolean isModel = false;
                CodegenProperty item = p;
                if (ExtensionHelper.getBooleanValue(p, "x-is-container")) {
                    item = p.items;
                }
                boolean isString = ExtensionHelper.getBooleanValue(p, "x-is-string");
                boolean isPrimitiveType = ExtensionHelper.getBooleanValue(p, "x-is-primitive-type");
                boolean isContainer = ExtensionHelper.getBooleanValue(p, "x-is-container");
                boolean isInteger = ExtensionHelper.getBooleanValue(p, "x-is-integer");
                if (!(item == null || isString || isPrimitiveType || isContainer || isInteger || d.contains(item.datatype))) {
                    d.add(item.datatype);
                    isModel = true;
                }
                p.vendorExtensions.put("x-is-model-type", isModel);
            }
            this.modelDepends.put(m.name, d);
            this.orderedModels.add(model);
        }
        final Map deps = this.modelDepends;
        Collections.sort(this.orderedModels, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                List rhsList;
                Object v = lhs.get("model");
                String lhsName = ((CodegenModel)v).name;
                v = rhs.get("model");
                String rhsName = ((CodegenModel)v).name;
                List lhsList = (List)deps.get(lhsName);
                if (lhsList == (rhsList = (List)deps.get(rhsName))) {
                    return lhsName.compareTo(rhsName);
                }
                if (lhsList == null) {
                    return -1;
                }
                if (rhsList == null) {
                    return 1;
                }
                if (lhsList.contains(rhsName)) {
                    return 1;
                }
                if (rhsList.contains(lhsName)) {
                    return -1;
                }
                if (lhsList.size() < rhsList.size()) {
                    return -1;
                }
                if (lhsList.size() > rhsList.size()) {
                    return 1;
                }
                return lhsName.compareTo(rhsName);
            }
        });
        return this.postProcessModelsEnum(objs);
    }
}

