/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractScalaCodegen;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ScalaGatlingCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    protected String sourceFolder = "src" + File.separator + "gatling" + File.separator + "scala";
    protected String resourceFolder = "src" + File.separator + "gatling" + File.separator + "resources";
    protected String confFolder = this.resourceFolder + File.separator + "conf";
    protected String dataFolder = this.resourceFolder + File.separator + "data";
    protected String apiVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "scala-gatling";
    }

    @Override
    public String getHelp() {
        return "Generates a gatling simulation library (beta).";
    }

    public ScalaGatlingCodegen() {
        this.outputFolder = "generated-code/gatling";
        this.apiTemplateFiles.put("api.mustache", "Simulation.scala");
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.templateDir = "scala-gatling";
        this.apiPackage = "io.swagger.client.api";
        this.modelPackage = "io.swagger.client.model";
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("build.gradle", "", "build.gradle"));
        this.supportingFiles.add(new SupportingFile("logback.xml", this.confFolder, "logback.xml"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "default.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "CI.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "CD.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "stress.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "baseline.conf"));
        this.supportingFiles.add(new SupportingFile("default.conf.mustache", this.confFolder, "longevity.conf"));
        this.importMapping.remove("List");
        this.importMapping.remove("Set");
        this.importMapping.remove("Map");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("ListBuffer", "scala.collection.mutable.ListBuffer");
        this.typeMapping = new HashMap();
        this.typeMapping.put("enum", "NSString");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("int", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("byte", "Byte");
        this.typeMapping.put("short", "Short");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("object", "Any");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("date-time", "Date");
        this.typeMapping.put("DateTime", "Date");
        this.instantiationTypes.put("array", "ListBuffer");
        this.instantiationTypes.put("map", "HashMap");
        this.setReservedWordsLowerCase(Arrays.asList("path", "contentTypes", "contentType", "queryParams", "headerParams", "formParams", "postBody", "mp", "basePath", "apiInvoker", "abstract", "case", "catch", "class", "def", "do", "else", "extends", "false", "final", "finally", "for", "forSome", "if", "implicit", "import", "lazy", "match", "new", "null", "object", "override", "package", "private", "protected", "return", "sealed", "super", "this", "throw", "trait", "try", "true", "type", "val", "var", "while", "with", "yield"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public void preprocessSwagger(Swagger swagger) {
        for (String pathname : swagger.getPaths().keySet()) {
            Path path = swagger.getPath(pathname);
            if (path.getOperations() == null) continue;
            for (Operation operation : path.getOperations()) {
                if (!operation.getVendorExtensions().keySet().contains("x-gatling-path")) {
                    if (pathname.contains("{")) {
                        String gatlingPath = pathname.replaceAll("\\{", "\\$\\{");
                        operation.setVendorExtension("x-gatling-path", (Object)gatlingPath);
                    } else {
                        operation.setVendorExtension("x-gatling-path", (Object)pathname);
                    }
                }
                HashSet<Parameter> headerParameters = new HashSet<Parameter>();
                HashSet<Parameter> formParameters = new HashSet<Parameter>();
                HashSet<Parameter> queryParameters = new HashSet<Parameter>();
                HashSet<Parameter> pathParameters = new HashSet<Parameter>();
                for (Parameter parameter : operation.getParameters()) {
                    if (parameter.getIn().equalsIgnoreCase("header")) {
                        headerParameters.add(parameter);
                    }
                    if (parameter.getIn().equalsIgnoreCase("formData")) {
                        formParameters.add(parameter);
                    }
                    if (parameter.getIn().equalsIgnoreCase("query")) {
                        queryParameters.add(parameter);
                    }
                    if (parameter.getIn().equalsIgnoreCase("path")) {
                        pathParameters.add(parameter);
                    }
                    if (!parameter.getIn().equalsIgnoreCase("body")) continue;
                    BodyParameter bodyParameter = (BodyParameter)parameter;
                    Model model = bodyParameter.getSchema();
                    if (model instanceof RefModel) {
                        String[] refArray = model.getReference().split("\\/");
                        operation.setVendorExtension("x-gatling-body-object", (Object)(refArray[refArray.length - 1] + ".toStringBody"));
                        HashSet bodyFeederParams = new HashSet();
                        HashSet<String> sessionBodyVars = new HashSet<String>();
                        for (Map.Entry modelEntry : swagger.getDefinitions().entrySet()) {
                            if (!refArray[refArray.length - 1].equalsIgnoreCase((String)modelEntry.getKey())) continue;
                            for (Map.Entry propertyEntry : ((Model)modelEntry.getValue()).getProperties().entrySet()) {
                                bodyFeederParams.add(propertyEntry.getKey());
                                sessionBodyVars.add("\"${" + (String)propertyEntry.getKey() + "}\"");
                            }
                        }
                        operation.setVendorExtension("x-gatling-body-feeder", (Object)(operation.getOperationId() + "BodyFeeder"));
                        operation.setVendorExtension("x-gatling-body-feeder-params", (Object)StringUtils.join(sessionBodyVars, (String)","));
                        try {
                            FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + this.dataFolder + File.separator + operation.getOperationId() + "-bodyParams.csv"), (String)StringUtils.join(bodyFeederParams, (String)","));
                        }
                        catch (IOException ioe) {
                            LOGGER.error("Could not create feeder file for operationId" + operation.getOperationId(), (Throwable)ioe);
                        }
                        continue;
                    }
                    if (model instanceof ArrayModel) {
                        operation.setVendorExtension("x-gatling-body-object", (Object)"StringBody(\"[]\")");
                        continue;
                    }
                    operation.setVendorExtension("x-gatling-body-object", (Object)"StringBody(\"{}\")");
                }
                this.prepareGatlingData(operation, headerParameters, "header");
                this.prepareGatlingData(operation, formParameters, "form");
                this.prepareGatlingData(operation, queryParameters, "query");
                this.prepareGatlingData(operation, pathParameters, "path");
            }
        }
    }

    private void prepareGatlingData(Operation operation, Set<Parameter> parameters, String parameterType) {
        if (parameters.size() > 0) {
            ArrayList<String> parameterNames = new ArrayList<String>();
            ArrayList vendorList = new ArrayList();
            for (Parameter parameter : parameters) {
                HashMap<String, String> extensionMap = new HashMap<String, String>();
                extensionMap.put("gatlingParamName", parameter.getName());
                extensionMap.put("gatlingParamValue", "${" + parameter.getName() + "}");
                vendorList.add(extensionMap);
                parameterNames.add(parameter.getName());
            }
            operation.setVendorExtension("x-gatling-" + parameterType.toLowerCase() + "-params", vendorList);
            operation.setVendorExtension("x-gatling-" + parameterType.toLowerCase() + "-feeder", (Object)(operation.getOperationId() + parameterType.toUpperCase() + "Feeder"));
            try {
                FileUtils.writeStringToFile((File)new File(this.outputFolder + File.separator + this.dataFolder + File.separator + operation.getOperationId() + "-" + parameterType.toLowerCase() + "Params.csv"), (String)StringUtils.join(parameterNames, (String)","));
            }
            catch (IOException ioe) {
                LOGGER.error("Could not create feeder file for operationId" + operation.getOperationId(), (Throwable)ioe);
            }
        }
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }
}

