/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    static Logger LOGGER = LoggerFactory.getLogger(PhpClientCodegen.class);
    public static final String VARIABLE_NAMING_CONVENTION = "variableNamingConvention";
    public static final String PACKAGE_PATH = "packagePath";
    public static final String SRC_BASE_PATH = "srcBasePath";
    public static final String COMPOSER_VENDOR_NAME = "composerVendorName";
    public static final String COMPOSER_PROJECT_NAME = "composerProjectName";
    protected String invokerPackage = "Swagger\\Client";
    protected String composerVendorName = null;
    protected String composerProjectName = null;
    protected String packagePath = "SwaggerClient-php";
    protected String artifactVersion = null;
    protected String srcBasePath = "lib";
    protected String testBasePath = "test";
    protected String docsBasePath = "docs";
    protected String apiDirName = "Api";
    protected String modelDirName = "Model";
    protected String variableNamingConvention = "snake_case";
    protected String apiDocPath = this.docsBasePath + "/" + this.apiDirName;
    protected String modelDocPath = this.docsBasePath + "/" + this.modelDirName;

    public PhpClientCodegen() {
        this.importMapping.clear();
        this.supportsInheritance = true;
        this.outputFolder = "generated-code" + File.separator + "php";
        this.modelTemplateFiles.put("model.mustache", ".php");
        this.apiTemplateFiles.put("api.mustache", ".php");
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.apiTestTemplateFiles.put("api_test.mustache", ".php");
        this.templateDir = "php";
        this.embeddedTemplateDir = "php";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("resourcePath", "httpBody", "queryParams", "headerParams", "formParams", "_header_accept", "_tempBody", "__halt_compiler", "abstract", "and", "array", "as", "break", "callable", "case", "catch", "class", "clone", "const", "continue", "declare", "default", "die", "do", "echo", "else", "elseif", "empty", "enddeclare", "endfor", "endforeach", "endif", "endswitch", "endwhile", "eval", "exit", "extends", "final", "for", "foreach", "function", "global", "goto", "if", "implements", "include", "include_once", "instanceof", "insteadof", "interface", "isset", "list", "namespace", "new", "or", "print", "private", "protected", "public", "require", "require_once", "return", "static", "switch", "throw", "trait", "try", "unset", "use", "var", "while", "xor"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "boolean", "int", "integer", "double", "float", "string", "object", "DateTime", "mixed", "number", "void", "byte"));
        this.instantiationTypes.put("array", "array");
        this.instantiationTypes.put("map", "map");
        ArrayList sortedLanguageSpecificPrimitives = new ArrayList(this.languageSpecificPrimitives);
        Collections.sort(sortedLanguageSpecificPrimitives);
        String primitives = "'" + StringUtils.join(sortedLanguageSpecificPrimitives, (String)"', '") + "'";
        this.additionalProperties.put("primitives", primitives);
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("number", "float");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("byte", "int");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "\\DateTime");
        this.typeMapping.put("Date", "\\DateTime");
        this.typeMapping.put("DateTime", "\\DateTime");
        this.typeMapping.put("file", "\\SplFileObject");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("array", "array");
        this.typeMapping.put("list", "array");
        this.typeMapping.put("object", "object");
        this.typeMapping.put("binary", "string");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption(VARIABLE_NAMING_CONVENTION, "naming convention of variable name, e.g. camelCase.").defaultValue("snake_case"));
        this.cliOptions.add(new CliOption("invokerPackage", "The main namespace to use for all classes. e.g. Yay\\Pets"));
        this.cliOptions.add(new CliOption(PACKAGE_PATH, "The main package name for classes. e.g. GeneratedPetstore"));
        this.cliOptions.add(new CliOption(SRC_BASE_PATH, "The directory under packagePath to serve as source root."));
        this.cliOptions.add(new CliOption(COMPOSER_VENDOR_NAME, "The vendor name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. yaypets. IMPORTANT NOTE (2016/03): composerVendorName will be deprecated and replaced by gitUserId in the next swagger-codegen release"));
        this.cliOptions.add(new CliOption("gitUserId", "Git user ID, e.g. swagger-api."));
        this.cliOptions.add(new CliOption(COMPOSER_PROJECT_NAME, "The project name used in the composer package name. The template uses {{composerVendorName}}/{{composerProjectName}} for the composer package name. e.g. petstore-client. IMPORTANT NOTE (2016/03): composerProjectName will be deprecated and replaced by gitRepoId in the next swagger-codegen release"));
        this.cliOptions.add(new CliOption("gitRepoId", "Git repo ID, e.g. swagger-codegen."));
        this.cliOptions.add(new CliOption("gitRepoBaseURL", "Git repo base URL, e.g. https://github.com."));
        this.cliOptions.add(new CliOption("artifactVersion", "The version to use in the composer package version field. e.g. 1.2.3"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "boolean, toggles whether unicode identifiers are allowed in names or not, default is false").defaultValue(Boolean.TRUE.toString()));
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String toPackagePath(String packageName, String basePath) {
        return this.getPackagePath() + File.separatorChar + this.toSrcPath(packageName, basePath);
    }

    public String toSrcPath(String packageName, String basePath) {
        packageName = packageName.replace(this.invokerPackage, "");
        if (basePath != null && basePath.length() > 0) {
            basePath = basePath.replaceAll("[\\\\/]?$", "") + File.separatorChar;
        }
        String regFirstPathSeparator = "/".equals(File.separator) ? "^/" : "^\\\\";
        String regLastPathSeparator = "/".equals(File.separator) ? "/$" : "\\\\$";
        return (basePath + packageName.replaceAll("[\\.\\\\/]", Matcher.quoteReplacement(File.separator)).replaceAll(regFirstPathSeparator, "")).replaceAll(regLastPathSeparator + "$", "");
    }

    @Override
    public String escapeText(String input) {
        if (input != null) {
            return super.escapeText(input).trim();
        }
        return input;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "php";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(PACKAGE_PATH)) {
            this.setPackagePath((String)this.additionalProperties.get(PACKAGE_PATH));
        } else {
            this.additionalProperties.put(PACKAGE_PATH, this.packagePath);
        }
        if (this.additionalProperties.containsKey(SRC_BASE_PATH)) {
            this.setSrcBasePath((String)this.additionalProperties.get(SRC_BASE_PATH));
        } else {
            this.additionalProperties.put(SRC_BASE_PATH, this.srcBasePath);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.setInvokerPackage((String)this.additionalProperties.get("invokerPackage"));
            this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
            this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("modelPackage");
        }
        this.additionalProperties.put("modelPackage", this.modelPackage);
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("apiPackage");
        }
        this.additionalProperties.put("apiPackage", this.apiPackage);
        if (this.additionalProperties.containsKey(COMPOSER_PROJECT_NAME)) {
            this.setComposerProjectName((String)this.additionalProperties.get(COMPOSER_PROJECT_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_PROJECT_NAME, this.composerProjectName);
        }
        if (this.additionalProperties.containsKey("gitUserId")) {
            this.setGitUserId((String)this.additionalProperties.get("gitUserId"));
        } else {
            this.additionalProperties.put("gitUserId", this.gitUserId);
        }
        if (this.additionalProperties.containsKey(COMPOSER_VENDOR_NAME)) {
            this.setComposerVendorName((String)this.additionalProperties.get(COMPOSER_VENDOR_NAME));
        } else {
            this.additionalProperties.put(COMPOSER_VENDOR_NAME, this.composerVendorName);
        }
        if (this.additionalProperties.containsKey("gitRepoId")) {
            this.setGitRepoId((String)this.additionalProperties.get("gitRepoId"));
        } else {
            this.additionalProperties.put("gitRepoId", this.gitRepoId);
        }
        if (this.additionalProperties.containsKey("gitRepoBaseURL")) {
            this.setGitRepoBaseURL((String)this.additionalProperties.get("gitRepoBaseURL"));
        } else {
            if (this.gitRepoBaseURL == null) {
                this.gitRepoBaseURL = "github";
            }
            this.additionalProperties.put("gitRepoBaseURL", this.gitRepoBaseURL);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey(VARIABLE_NAMING_CONVENTION)) {
            this.setParameterNamingConvention((String)this.additionalProperties.get(VARIABLE_NAMING_CONVENTION));
        }
        this.additionalProperties.put("escapedInvokerPackage", this.invokerPackage.replace("\\", "\\\\"));
        this.additionalProperties.put("apiSrcPath", "./" + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("apiTestPath", "./" + this.testBasePath + "/" + this.apiDirName);
        this.additionalProperties.put("modelTestPath", "./" + this.testBasePath + "/" + this.modelDirName);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.additionalProperties.put("testBasePath", this.testBasePath);
        this.supportingFiles.add(new SupportingFile("ApiException.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "ApiException.php"));
        this.supportingFiles.add(new SupportingFile("Configuration.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "Configuration.php"));
        this.supportingFiles.add(new SupportingFile("ObjectSerializer.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "ObjectSerializer.php"));
        this.supportingFiles.add(new SupportingFile("ModelInterface.mustache", this.toPackagePath(this.modelPackage, this.srcBasePath), "ModelInterface.php"));
        this.supportingFiles.add(new SupportingFile("HeaderSelector.mustache", this.toPackagePath(this.invokerPackage, this.srcBasePath), "HeaderSelector.php"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.getPackagePath(), "composer.json"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getPackagePath(), "README.md"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", this.getPackagePath(), "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile(".travis.yml", this.getPackagePath(), ".travis.yml"));
        this.supportingFiles.add(new SupportingFile(".php_cs", this.getPackagePath(), ".php_cs"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", this.getPackagePath(), "git_push.sh"));
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.toPackagePath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.toPackagePath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.testBasePath + "/" + this.apiDirName;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.testBasePath + "/" + this.modelDirName;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + "/" + this.getPackagePath() + "/" + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[string," + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof RefProperty) {
            String type = super.getTypeDeclaration(p);
            return !this.languageSpecificPrimitives.contains(type) ? "\\" + this.modelPackage + "\\" + type : type;
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getTypeDeclaration(String name) {
        if (!this.languageSpecificPrimitives.contains(name)) {
            return "\\" + this.modelPackage + "\\" + name;
        }
        return super.getTypeDeclaration(name);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
            if (this.instantiationTypes.containsKey(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            return null;
        }
        return this.toModelName(type);
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public void setSrcBasePath(String srcBasePath) {
        this.srcBasePath = srcBasePath;
    }

    public void setParameterNamingConvention(String variableNamingConvention) {
        this.variableNamingConvention = variableNamingConvention;
    }

    public void setComposerVendorName(String composerVendorName) {
        this.composerVendorName = composerVendorName;
    }

    public void setComposerProjectName(String composerProjectName) {
        this.composerProjectName = composerProjectName;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        name = "camelCase".equals(this.variableNamingConvention) ? PhpClientCodegen.camelize(name, true) : PhpClientCodegen.underscore(name);
        if (name.matches("^\\d.*")) {
            name = "_" + name;
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        name = name.replaceAll("\\]", "");
        name = name.replaceAll("[^\\w\\\\]+", "_");
        if (this.isReservedWord(name = name.replaceAll("$", ""))) {
            LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + PhpClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (name.matches("^\\d.*")) {
            LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + PhpClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (!name.matches("^\\\\.*")) {
            if (!StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
                name = this.modelNamePrefix + "_" + name;
            }
            if (!StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
                name = name + "_" + this.modelNameSuffix;
            }
        }
        return PhpClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelName(name) + "Test";
    }

    @Override
    public String toOperationId(String operationId) {
        if (StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + PhpClientCodegen.camelize(this.sanitizeName("call_" + operationId), true));
            operationId = "call_" + operationId;
        }
        return PhpClientCodegen.camelize(this.sanitizeName(operationId), true);
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty dp = (StringProperty)p;
            if (dp.getDefault() != null) {
                return "'" + dp.getDefault() + "'";
            }
        } else if (p instanceof BooleanProperty) {
            BooleanProperty dp = (BooleanProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
        } else if (!(p instanceof DateProperty) && !(p instanceof DateTimeProperty)) {
            LongProperty dp;
            if (p instanceof DoubleProperty) {
                DoubleProperty dp2 = (DoubleProperty)p;
                if (dp2.getDefault() != null) {
                    return dp2.getDefault().toString();
                }
            } else if (p instanceof FloatProperty) {
                FloatProperty dp3 = (FloatProperty)p;
                if (dp3.getDefault() != null) {
                    return dp3.getDefault().toString();
                }
            } else if (p instanceof IntegerProperty) {
                IntegerProperty dp4 = (IntegerProperty)p;
                if (dp4.getDefault() != null) {
                    return dp4.getDefault().toString();
                }
            } else if (p instanceof LongProperty && (dp = (LongProperty)p).getDefault() != null) {
                return dp.getDefault().toString();
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        String example = p.defaultValue == null ? p.example : p.defaultValue;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("String".equalsIgnoreCase(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("Integer".equals(type) || "int".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("Float".equalsIgnoreCase(type) || "Double".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("BOOLEAN".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "True";
            }
        } else if ("\\SplFileObject".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "\"" + this.escapeText(example) + "\"";
        } else if ("\\Date".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("\\DateTime".equalsIgnoreCase(type)) {
            if (example == null) {
                example = "2013-10-20T19:20:30+01:00";
            }
            example = "new \\DateTime(\"" + this.escapeText(example) + "\")";
        } else if ("object".equals(type)) {
            example = "new \\stdClass";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = "new " + this.getTypeDeclaration(type) + "()";
        } else {
            LOGGER.warn("Type " + type + " not handled properly in setParameterExampleValue");
        }
        if (example == null) {
            example = "NULL";
        } else if (Boolean.TRUE.equals(p.isListContainer)) {
            example = "array(" + example + ")";
        } else if (Boolean.TRUE.equals(p.isMapContainer)) {
            example = "array('key' => " + example + ")";
        }
        p.example = example;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase();
        }
        String enumName = this.sanitizeName(PhpClientCodegen.underscore(name).toUpperCase());
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = PhpClientCodegen.underscore(this.toModelName(property.name)).toUpperCase();
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("x-testOperationId", PhpClientCodegen.camelize(op.operationId));
        }
        return objs;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

