/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen;

import config.Config;
import config.ConfigParser;
import io.swagger.codegen.CliOption;
import io.swagger.codegen.ClientOptInput;
import io.swagger.codegen.ClientOpts;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.DefaultGenerator;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Codegen
extends DefaultGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Codegen.class);
    static Map<String, CodegenConfig> configs = new HashMap<String, CodegenConfig>();
    static String configString;
    static String debugInfoOptions;

    public static void main(String[] args) {
        Options options = new Options();
        options.addOption("h", "help", false, "shows this message");
        options.addOption("l", "lang", true, "client language to generate.\nAvailable languages include:\n\t[" + configString + "]");
        options.addOption("o", "output", true, "where to write the generated files");
        options.addOption("i", "input-spec", true, "location of the swagger spec, as URL or file");
        options.addOption("t", "template-dir", true, "folder containing the template files");
        options.addOption("d", "debug-info", false, "prints additional info for debugging");
        options.addOption("a", "auth", true, "adds authorization headers when fetching the swagger definitions remotely. Pass in a URL-encoded string of name:header with a comma separating multiple values");
        options.addOption("c", "config", true, "location of the configuration file");
        ClientOptInput clientOptInput = new ClientOptInput();
        ClientOpts clientOpts = new ClientOpts();
        Swagger swagger = null;
        CommandLine cmd = null;
        try {
            BasicParser parser = new BasicParser();
            CodegenConfig config = null;
            cmd = parser.parse(options, args);
            if (cmd.hasOption("d")) {
                Codegen.usage(options);
                System.out.println(debugInfoOptions);
                return;
            }
            if (cmd.hasOption("a")) {
                clientOptInput.setAuth(cmd.getOptionValue("a"));
            }
            if (!cmd.hasOption("l")) {
                Codegen.usage(options);
                return;
            }
            clientOptInput.setConfig(Codegen.getConfig(cmd.getOptionValue("l")));
            if (cmd.hasOption("o")) {
                clientOptInput.getConfig().setOutputDir(cmd.getOptionValue("o"));
            }
            if (cmd.hasOption("h")) {
                if (cmd.hasOption("l") && (config = Codegen.getConfig(String.valueOf(cmd.getOptionValue("l")))) != null) {
                    options.addOption("h", "help", true, config.getHelp());
                    Codegen.usage(options);
                    return;
                }
                Codegen.usage(options);
                return;
            }
            if (cmd.hasOption("i")) {
                swagger = new SwaggerParser().read(cmd.getOptionValue("i"), clientOptInput.getAuthorizationValues(), true);
            }
            if (cmd.hasOption("c")) {
                String configFile = cmd.getOptionValue("c");
                Config genConfig = ConfigParser.read(configFile);
                config = clientOptInput.getConfig();
                if (null != genConfig && null != config) {
                    for (CliOption langCliOption : config.cliOptions()) {
                        if (!genConfig.hasOption(langCliOption.getOpt())) continue;
                        config.additionalProperties().put(langCliOption.getOpt(), genConfig.getOption(langCliOption.getOpt()));
                    }
                }
            }
            if (cmd.hasOption("t")) {
                clientOpts.getProperties().put("templateDir", String.valueOf(cmd.getOptionValue("t")));
            }
        }
        catch (Exception e) {
            Codegen.usage(options);
            return;
        }
        try {
            clientOptInput.opts(clientOpts).swagger(swagger);
            new Codegen().opts(clientOptInput).generate();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static List<CodegenConfig> getExtensions() {
        ServiceLoader<CodegenConfig> loader = ServiceLoader.load(CodegenConfig.class);
        ArrayList<CodegenConfig> output = new ArrayList<CodegenConfig>();
        for (CodegenConfig aLoader : loader) {
            output.add(aLoader);
        }
        return output;
    }

    static void usage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Codegen", options);
    }

    public static CodegenConfig getConfig(String name) {
        if (configs.containsKey(name)) {
            return configs.get(name);
        }
        try {
            LOGGER.debug("loading class " + name);
            Class<?> customClass = Class.forName(name);
            LOGGER.debug("loaded");
            return (CodegenConfig)customClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("can't load class " + name);
        }
    }

    static {
        debugInfoOptions = "\nThe following additional debug options are available for all codegen targets:\n -DdebugSwagger prints the swagger specification as interpreted by the codegen\n -DdebugModels prints models passed to the template engine\n -DdebugOperations prints operations passed to the template engine\n -DdebugSupportingFiles prints additional data passed to the template engine";
        List<CodegenConfig> extensions = Codegen.getExtensions();
        StringBuilder sb = new StringBuilder();
        for (CodegenConfig config : extensions) {
            if (sb.toString().length() != 0) {
                sb.append(", ");
            }
            sb.append(config.getName());
            configs.put(config.getName(), config);
            configString = sb.toString();
        }
    }
}

