/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ScalatraServerCodegen
extends DefaultCodegen
implements CodegenConfig {
    protected String invokerPackage = "io.swagger.client";
    protected String groupId = "io.swagger";
    protected String artifactId = "swagger-client";
    protected String artifactVersion = "1.0.0";
    protected String sourceFolder = "src/main/scala";

    public ScalatraServerCodegen() {
        this.outputFolder = "generated-code/scalatra";
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.templateDir = "scalatra";
        this.embeddedTemplateDir = "scalatra";
        this.apiPackage = "com.wordnik.client.api";
        this.modelPackage = "com.wordnik.client.model";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "List", "Set", "Map"));
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("binary", "String");
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appName", "Swagger Sample");
        this.additionalProperties.put("appDescription", "A sample swagger server");
        this.additionalProperties.put("infoUrl", "http://swagger.io");
        this.additionalProperties.put("infoEmail", "apiteam@swagger.io");
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.additionalProperties.put("artifactVersion", this.artifactVersion);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("web.xml", "/src/main/webapp/WEB-INF", "web.xml"));
        this.supportingFiles.add(new SupportingFile("JettyMain.mustache", this.sourceFolder, "JettyMain.scala"));
        this.supportingFiles.add(new SupportingFile("Bootstrap.mustache", this.sourceFolder, "ScalatraBootstrap.scala"));
        this.supportingFiles.add(new SupportingFile("ServletApp.mustache", this.sourceFolder, "ServletApp.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt", "project", "plugins.sbt"));
        this.supportingFiles.add(new SupportingFile("sbt", "", "sbt"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object"));
        this.instantiationTypes.put("array", "ArrayList");
        this.instantiationTypes.put("map", "HashMap");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "java.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.util.Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "java.util.Map");
        this.importMapping.put("HashMap", "java.util.HashMap");
        this.importMapping.put("Array", "java.util.List");
        this.importMapping.put("ArrayList", "java.util.ArrayList");
        this.importMapping.put("DateTime", "org.joda.time.DateTime");
        this.importMapping.put("LocalDateTime", "org.joda.time.LocalDateTime");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.importMapping.put("LocalTime", "org.joda.time.LocalTime");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scalatra";
    }

    @Override
    public String getHelp() {
        return "Generates a Scala server application with Scalatra.";
    }

    @Override
    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            op.httpMethod = op.httpMethod.toLowerCase();
        }
        return objs;
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "[String, " + this.getTypeDeclaration(inner) + "]";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }
}

