/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.ubt;

import android.content.Context;
import com.ikala.android.ubt.UBTEventBroadcastReciever;
import com.ikala.android.ubt.UBT_Event;
import com.ikala.android.ubt.UBT_Instance;
import com.ikala.android.ubt.UBT_Observer;
import com.ikala.android.ubt.UBT_UserInfo;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class UBT_Observable {
    protected WeakReference<Context> a = null;
    public Vector<UBT_Observer> mObservers = new Vector();

    public UBT_Observable() {
    }

    public UBT_Observable(Context context) {
        this();
        if (null != context) {
            this.a = new WeakReference<Context>(context);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (null != this.mObservers) {
            this.mObservers.clear();
            this.mObservers = null;
        }
    }

    public void registerObserver(UBT_Observer uBT_Observer) {
        this.mObservers.add(uBT_Observer);
    }

    public void removeObserver(UBT_Observer uBT_Observer) {
        this.mObservers.remove(uBT_Observer);
    }

    public void preProc() {
        Context context = (Context)this.a.get();
        for (int i = 0; i < this.mObservers.size(); ++i) {
            UBT_Observer uBT_Observer = this.mObservers.get(i);
            uBT_Observer.preProc(context);
        }
    }

    public void postProc() {
        for (int i = 0; i < this.mObservers.size(); ++i) {
            UBT_Observer uBT_Observer = this.mObservers.get(i);
            uBT_Observer.postProc();
        }
    }

    public void sessionBegin(Context context, int n) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.sessionBegin(context, n);
            }
        } else if (context != null) {
            UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.StartSession, null);
        }
    }

    public void sessionEnd(Context context, int n) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.sessionEnd(context, n);
            }
        } else if (context != null) {
            UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.EndSession, null);
        }
    }

    public void eventBegin(UBT_Event uBT_Event, int n) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.eventBegin(uBT_Event, n);
            }
        } else {
            Context context = (Context)this.a.get();
            if (null != context) {
                UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.BeginEvent, uBT_Event);
            }
        }
    }

    public void eventEnd(UBT_Event uBT_Event, int n) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.eventEnd(uBT_Event, n);
            }
        } else {
            Context context = (Context)this.a.get();
            if (null != context) {
                UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.EndEvent, uBT_Event);
            }
        }
    }

    public void userInfo(UBT_UserInfo uBT_UserInfo) {
        for (int i = 0; i < this.mObservers.size(); ++i) {
            UBT_Observer uBT_Observer = this.mObservers.get(i);
            uBT_Observer.userInfo(uBT_UserInfo);
        }
    }
}

