/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.types.ResolvedInterfaceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mapstruct.Mapper;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.ApiListing;
import springfox.documentation.swagger2.mappers.Properties;

@Mapper
public abstract class ModelMapper {
    public Map<String, io.swagger.models.Model> mapModels(Map<String, Model> from) {
        if (from == null) {
            return null;
        }
        HashMap<String, io.swagger.models.Model> map = new HashMap<String, io.swagger.models.Model>();
        for (Map.Entry<String, Model> entry : from.entrySet()) {
            String key = entry.getKey();
            io.swagger.models.Model value = this.mapProperties(entry.getValue());
            map.put(key, value);
        }
        return map;
    }

    public io.swagger.models.Model mapProperties(Model source) {
        ModelImpl model = new ModelImpl().description(source.getDescription()).discriminator(source.getDiscriminator()).example((Object)source.getExample()).name(source.getName());
        TreeMap sorted = Maps.newTreeMap();
        sorted.putAll(this.mapProperties(source.getProperties()));
        model.setProperties((Map)sorted);
        FluentIterable requiredFields = FluentIterable.from(source.getProperties().values()).filter(this.requiredProperty()).transform(this.propertyName());
        model.setRequired((List)requiredFields.toList());
        model.setSimple(false);
        if (this.isInterface(source.getType())) {
            model.setType("object");
        }
        if (springfox.documentation.schema.Maps.isMapType((ResolvedType)source.getType())) {
            Optional<Class> clazz = this.typeOfValue(source);
            if (clazz.isPresent()) {
                model.additionalProperties(Properties.property(((Class)clazz.get()).getSimpleName()));
            } else {
                model.additionalProperties((Property)new ObjectProperty());
            }
        }
        return model;
    }

    private boolean isInterface(ResolvedType type) {
        return type instanceof ResolvedInterfaceType;
    }

    @VisibleForTesting
    Optional<Class> typeOfValue(Model source) {
        Optional<ResolvedType> mapInterface = this.findMapInterface(source.getType());
        if (mapInterface.isPresent()) {
            return Optional.of((Object)((ResolvedType)((ResolvedType)mapInterface.get()).getTypeParameters().get(1)).getErasedType());
        }
        return Optional.absent();
    }

    private Optional<ResolvedType> findMapInterface(ResolvedType type) {
        return Optional.fromNullable((Object)type.findSupertype(Map.class));
    }

    public Property mapProperty(ModelProperty source) {
        AllowableRangeValues range;
        AllowableValues allowableValues;
        Property property = ModelMapper.modelRefToProperty(source.getModelRef());
        ModelMapper.addEnumValues(property, source.getAllowableValues());
        if (property instanceof ArrayProperty) {
            ArrayProperty arrayProperty = (ArrayProperty)property;
            ModelMapper.addEnumValues(arrayProperty.getItems(), source.getAllowableValues());
        }
        if (property instanceof AbstractNumericProperty && (allowableValues = source.getAllowableValues()) instanceof AllowableRangeValues) {
            range = (AllowableRangeValues)allowableValues;
            ((AbstractNumericProperty)property).maximum(Double.valueOf(range.getMax()));
            ((AbstractNumericProperty)property).minimum(Double.valueOf(range.getMin()));
        }
        if (property instanceof StringProperty && (allowableValues = source.getAllowableValues()) instanceof AllowableRangeValues) {
            range = (AllowableRangeValues)allowableValues;
            ((StringProperty)property).maxLength(Integer.valueOf(range.getMax()));
            ((StringProperty)property).minLength(Integer.valueOf(range.getMin()));
        }
        if (property != null) {
            property.setDescription(source.getDescription());
            property.setName(source.getName());
            property.setRequired(source.isRequired().booleanValue());
            property.setReadOnly(source.isReadOnly());
            property.setExample(source.getExample());
        }
        return property;
    }

    private static Property addEnumValues(Property property, AllowableValues allowableValues) {
        if (property instanceof StringProperty && allowableValues instanceof AllowableListValues) {
            StringProperty stringProperty = (StringProperty)property;
            AllowableListValues listValues = (AllowableListValues)allowableValues;
            stringProperty.setEnum(listValues.getValues());
        }
        return property;
    }

    static Property modelRefToProperty(ModelRef modelRef) {
        Property responseProperty;
        if (modelRef == null || "void".equalsIgnoreCase(modelRef.getType())) {
            return null;
        }
        if (modelRef.isCollection()) {
            String itemType = modelRef.getItemType();
            responseProperty = new ArrayProperty(ModelMapper.addEnumValues(Properties.property(itemType), modelRef.getAllowableValues()));
        } else if (modelRef.isMap()) {
            String itemType = modelRef.getItemType();
            responseProperty = new MapProperty(Properties.property(itemType));
        } else {
            responseProperty = Properties.property(modelRef.getType());
        }
        ModelMapper.addEnumValues(responseProperty, modelRef.getAllowableValues());
        return responseProperty;
    }

    protected Map<String, io.swagger.models.Model> modelsFromApiListings(Multimap<String, ApiListing> apiListings) {
        HashMap definitions = Maps.newHashMap();
        for (ApiListing each : apiListings.values()) {
            definitions.putAll(each.getModels());
        }
        return this.mapModels(definitions);
    }

    protected abstract Map<String, Property> mapProperties(Map<String, ModelProperty> var1);

    private Function<ModelProperty, String> propertyName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private Predicate<ModelProperty> requiredProperty() {
        return new Predicate<ModelProperty>(){

            public boolean apply(ModelProperty input) {
                return input.isRequired();
            }
        };
    }
}

