/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.parameter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.MethodParameter;

public class ParameterAnnotationReader {
    private ParameterAnnotationReader() {
        throw new UnsupportedOperationException();
    }

    public static <A extends Annotation> Optional<A> fromHierarchy(MethodParameter methodParameter, Class<A> annotationType) {
        return Optional.ofNullable(ParameterAnnotationReader.searchOnInterfaces(methodParameter.getMethod(), methodParameter.getParameterIndex(), annotationType, ParameterAnnotationReader.getParentInterfaces(methodParameter)));
    }

    private static Optional<Method> interfaceMethod(Class<?> iface, Method method) {
        try {
            return Optional.of(iface.getMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException ex) {
            return Optional.empty();
        }
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, int parameterIndex, Class<A> annotationType, Class<?>[] interfaces) {
        Annotation annotation = null;
        for (Class<?> interfaze : interfaces) {
            Optional<Method> interfaceMethod = ParameterAnnotationReader.interfaceMethod(interfaze, method);
            if (!interfaceMethod.isPresent()) continue;
            Method superMethod = interfaceMethod.get();
            Optional<Annotation> found = Stream.of(superMethod.getParameterAnnotations()[parameterIndex]).filter(input -> input.annotationType().equals(annotationType)).findFirst();
            if (found.isPresent()) {
                annotation = found.get();
                break;
            }
            Class<?>[] superInterfaces = superMethod.getDeclaringClass().getInterfaces();
            annotation = ParameterAnnotationReader.searchOnInterfaces(superMethod, parameterIndex, annotationType, superInterfaces);
        }
        return (A)annotation;
    }

    private static Class<?>[] getParentInterfaces(MethodParameter methodParameter) {
        return methodParameter.getMethod().getDeclaringClass().getInterfaces();
    }
}

