/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.annotations;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotationUtils;

public class Annotations {
    private Annotations() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ApiParam> findApiParamAnnotation(AnnotatedElement annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiParam.class));
    }

    public static List<ApiResponses> findApiResponsesAnnotations(AnnotatedElement annotated) {
        ApiResponses parentLevel;
        ArrayList results = Lists.newArrayList();
        ApiResponses currentLevel = (ApiResponses)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiResponses.class);
        if (currentLevel != null) {
            results.add(currentLevel);
        }
        if (annotated instanceof Method && (parentLevel = (ApiResponses)AnnotationUtils.findAnnotation(((Method)annotated).getDeclaringClass(), ApiResponses.class)) != null) {
            results.add(parentLevel);
        }
        return results;
    }

    public static Function<ApiOperation, ResolvedType> resolvedTypeFromOperation(final TypeResolver typeResolver, final ResolvedType defaultType) {
        return new Function<ApiOperation, ResolvedType>(){

            public ResolvedType apply(ApiOperation annotation) {
                return Annotations.getResolvedType(annotation, typeResolver, defaultType);
            }
        };
    }

    public static Function<ApiResponse, ResolvedType> resolvedTypeFromResponse(final TypeResolver typeResolver, final ResolvedType defaultType) {
        return new Function<ApiResponse, ResolvedType>(){

            public ResolvedType apply(ApiResponse annotation) {
                return Annotations.getResolvedType(annotation, typeResolver, defaultType);
            }
        };
    }

    @VisibleForTesting
    static ResolvedType getResolvedType(ApiOperation annotation, TypeResolver resolver, ResolvedType defaultType) {
        String responseContainer;
        Class response;
        if (null != annotation && Annotations.resolvedType(resolver, response = annotation.response(), responseContainer = annotation.responseContainer()).isPresent()) {
            return (ResolvedType)Annotations.resolvedType(resolver, response, responseContainer).get();
        }
        return defaultType;
    }

    @VisibleForTesting
    static ResolvedType getResolvedType(ApiResponse annotation, TypeResolver resolver, ResolvedType defaultType) {
        String responseContainer;
        Class response;
        if (null != annotation && Annotations.resolvedType(resolver, response = annotation.response(), responseContainer = annotation.responseContainer()).isPresent()) {
            return (ResolvedType)Annotations.resolvedType(resolver, response, responseContainer).get();
        }
        return defaultType;
    }

    private static Optional<ResolvedType> resolvedType(TypeResolver resolver, Class<?> response, String responseContainer) {
        if (Annotations.isNotVoid(response)) {
            if ("List".compareToIgnoreCase(responseContainer) == 0) {
                return Optional.of((Object)resolver.resolve(List.class, new Type[]{response}));
            }
            if ("Set".compareToIgnoreCase(responseContainer) == 0) {
                return Optional.of((Object)resolver.resolve(Set.class, new Type[]{response}));
            }
            return Optional.of((Object)resolver.resolve(response, new Type[0]));
        }
        return Optional.absent();
    }

    private static boolean isNotVoid(Class<?> response) {
        return Void.class != response && Void.TYPE != response;
    }
}

