/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.readers.operation.DefaultTagsProvider;
import springfox.documentation.swagger.annotations.Annotations;

@Component
@Order(value=-2147482648)
public class SwaggerOperationTagsReader
implements OperationBuilderPlugin {
    private final DefaultTagsProvider tagsProvider;

    @Autowired
    public SwaggerOperationTagsReader(DefaultTagsProvider tagsProvider) {
        this.tagsProvider = tagsProvider;
    }

    public void apply(OperationContext context) {
        ImmutableSet defaultTags = this.tagsProvider.tags(context);
        HandlerMethod handlerMethod = context.getHandlerMethod();
        Sets.SetView tags = Sets.union(this.operationTags(handlerMethod), this.controllerTags(handlerMethod));
        if (tags.isEmpty()) {
            context.operationBuilder().tags((Set)defaultTags);
        } else {
            context.operationBuilder().tags((Set)tags);
        }
    }

    private Set<String> controllerTags(HandlerMethod handlerMethod) {
        Class<?> controller = handlerMethod.getMethod().getDeclaringClass();
        Optional controllerAnnotation = Optional.fromNullable((Object)AnnotationUtils.findAnnotation(controller, Api.class));
        return (Set)controllerAnnotation.transform(this.tagsFromController()).or((Object)Sets.newHashSet());
    }

    private Set<String> operationTags(HandlerMethod handlerMethod) {
        Optional<ApiOperation> annotation = Annotations.findApiOperationAnnotation(handlerMethod.getMethod());
        return (Set)annotation.transform(this.tagsFromOperation()).or((Object)Sets.newHashSet());
    }

    private Function<ApiOperation, Set<String>> tagsFromOperation() {
        return new Function<ApiOperation, Set<String>>(){

            public Set<String> apply(ApiOperation input) {
                TreeSet tags = Sets.newTreeSet();
                tags.addAll(FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
                return tags;
            }
        };
    }

    private Function<Api, Set<String>> tagsFromController() {
        return new Function<Api, Set<String>>(){

            public Set<String> apply(Api input) {
                TreeSet tags = Sets.newTreeSet();
                tags.addAll(FluentIterable.from((Iterable)Lists.newArrayList((Object[])input.tags())).filter(Tags.emptyTags()).toSet());
                return tags;
            }
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

