/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.HandlerMethodReturnTypes;
import springfox.documentation.spring.web.readers.operation.ModelRefs;
import springfox.documentation.swagger.annotations.Annotations;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerOperationResponseClassReader
implements OperationBuilderPlugin {
    private static Logger log = LoggerFactory.getLogger(SwaggerOperationResponseClassReader.class);
    private final TypeResolver typeResolver;
    private final TypeNameExtractor nameExtractor;

    @Autowired
    public SwaggerOperationResponseClassReader(TypeResolver typeResolver, TypeNameExtractor nameExtractor) {
        this.typeResolver = typeResolver;
        this.nameExtractor = nameExtractor;
    }

    public void apply(OperationContext context) {
        HandlerMethod handlerMethod = context.getHandlerMethod();
        ResolvedType returnType = HandlerMethodReturnTypes.handlerReturnType((TypeResolver)this.typeResolver, (HandlerMethod)handlerMethod);
        returnType = context.alternateFor(returnType);
        returnType = (ResolvedType)Annotations.findApiOperationAnnotation(handlerMethod.getMethod()).transform(Annotations.resolvedTypeFromOperation(this.typeResolver, returnType)).or((Object)returnType);
        if (this.canSkip(context, returnType)) {
            return;
        }
        ModelContext modelContext = ModelContext.returnValue((Type)returnType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getDocumentationContext().getGenericsNamingStrategy());
        String responseTypeName = this.nameExtractor.typeName(modelContext);
        log.debug("Setting response class to:" + responseTypeName);
        context.operationBuilder().responseModel((ModelRef)ModelRefs.modelRef((Optional)Optional.of((Object)returnType), (ModelContext)modelContext, (TypeNameExtractor)this.nameExtractor).orNull());
    }

    private boolean canSkip(OperationContext context, ResolvedType returnType) {
        return context.getDocumentationContext().getIgnorableParameterTypes().contains((Object)returnType);
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

