/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class ResponseMessagesReader
implements OperationBuilderPlugin {
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public ResponseMessagesReader(TypeNameExtractor typeNameExtractor) {
        this.typeNameExtractor = typeNameExtractor;
    }

    public void apply(OperationContext context) {
        List responseMessages = context.getGlobalResponseMessages(context.httpMethod().toString());
        context.operationBuilder().responseMessages((Set)Sets.newHashSet((Iterable)responseMessages));
        this.applyReturnTypeOverride(context);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void applyReturnTypeOverride(OperationContext context) {
        ResolvedType returnType = context.alternateFor(context.getReturnType());
        int httpStatusCode = ResponseMessagesReader.httpStatusCode(context);
        String message = ResponseMessagesReader.message(context);
        ModelReference modelRef = null;
        if (!Types.isVoid((ResolvedType)returnType)) {
            ModelContext modelContext = ModelContext.returnValue((String)context.getGroupName(), (Type)returnType, (DocumentationType)context.getDocumentationType(), (AlternateTypeProvider)context.getAlternateTypeProvider(), (GenericTypeNamingStrategy)context.getGenericsNamingStrategy(), (ImmutableSet)context.getIgnorableParameterTypes());
            modelRef = (ModelReference)ResolvedTypes.modelRefFactory((ModelContext)modelContext, (TypeNameExtractor)this.typeNameExtractor).apply((Object)returnType);
        }
        ResponseMessage built = new ResponseMessageBuilder().code(httpStatusCode).message(message).responseModel(modelRef).build();
        context.operationBuilder().responseMessages((Set)Sets.newHashSet((Object[])new ResponseMessage[]{built}));
    }

    public static int httpStatusCode(OperationContext context) {
        Optional responseStatus = context.findAnnotation(ResponseStatus.class);
        int httpStatusCode = HttpStatus.OK.value();
        if (responseStatus.isPresent()) {
            httpStatusCode = ((ResponseStatus)responseStatus.get()).value().value();
        }
        return httpStatusCode;
    }

    public static String message(OperationContext context) {
        Optional responseStatus = context.findAnnotation(ResponseStatus.class);
        String reasonPhrase = HttpStatus.OK.getReasonPhrase();
        if (responseStatus.isPresent() && (reasonPhrase = ((ResponseStatus)responseStatus.get()).reason()).isEmpty()) {
            reasonPhrase = ((ResponseStatus)responseStatus.get()).value().getReasonPhrase();
        }
        return reasonPhrase;
    }
}

