/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483648)
public class ExpandedParameterBuilder
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterBuilder.class);
    private final TypeResolver resolver;

    @Autowired
    public ExpandedParameterBuilder(TypeResolver resolver) {
        this.resolver = resolver;
    }

    public void apply(ParameterExpansionContext context) {
        AllowableValues allowable = this.allowableValues(context.getField());
        String name = Strings.isNullOrEmpty((String)context.getParentName()) ? context.getField().getName() : String.format("%s.%s", context.getParentName(), context.getField().getName());
        String typeName = context.getDataTypeName();
        ModelRef itemModel = null;
        ResolvedType resolved = this.resolver.resolve(context.getField().getType(), new Type[0]);
        if (Collections.isContainerType((ResolvedType)resolved)) {
            resolved = (ResolvedType)this.fieldType(context).or((Object)resolved);
            ResolvedType elementType = Collections.collectionElementType((ResolvedType)resolved);
            String itemTypeName = Types.typeNameFor((Type)elementType.getErasedType());
            AllowableValues itemAllowables = null;
            if (elementType.getErasedType().isEnum()) {
                itemAllowables = Enums.allowableValues((Class)elementType.getErasedType());
                itemTypeName = "string";
            }
            typeName = Collections.containerType((ResolvedType)resolved);
            itemModel = new ModelRef(itemTypeName, itemAllowables);
        } else if (resolved.getErasedType().isEnum()) {
            typeName = "string";
        }
        context.getParameterBuilder().name(name).description(null).defaultValue(null).required(Boolean.FALSE.booleanValue()).allowMultiple(Collections.isContainerType((ResolvedType)resolved)).type(resolved).modelRef((ModelReference)new ModelRef(typeName, itemModel)).allowableValues(allowable).parameterType("query").parameterAccess(null);
    }

    private Optional<ResolvedType> fieldType(ParameterExpansionContext context) {
        try {
            if (context.getField().getType().isArray()) {
                return Optional.of((Object)this.resolver.arrayType(context.getField().getType().getComponentType()));
            }
            ParameterizedType parameterized = (ParameterizedType)context.getField().getGenericType();
            Optional itemClazz = FluentIterable.from((Iterable)Lists.newArrayList((Object[])parameterized.getActualTypeArguments())).first();
            if (itemClazz.isPresent()) {
                return Optional.of((Object)this.resolver.resolve(context.getField().getType(), new Type[]{(Type)itemClazz.get()}));
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to extract parameterized model attribute");
        }
        return Optional.absent();
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private AllowableValues allowableValues(Field field) {
        AllowableListValues allowable = null;
        if (field.getType().isEnum()) {
            allowable = new AllowableListValues(this.getEnumValues(field.getType()), "LIST");
        }
        return allowable;
    }

    private List<String> getEnumValues(Class<?> subject) {
        return Lists.transform(Arrays.asList(subject.getEnumConstants()), (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input.toString();
            }
        });
    }
}

