/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import springfox.documentation.builders.ApiDescriptionBuilder;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.PathContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.operation.ApiOperationReader;

@Component
public class ApiDescriptionReader {
    private final ApiOperationReader operationReader;
    private DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiDescriptionReader(ApiOperationReader operationReader, DocumentationPluginsManager pluginsManager) {
        this.operationReader = operationReader;
        this.pluginsManager = pluginsManager;
    }

    public List<ApiDescription> read(RequestMappingContext outerContext) {
        RequestMappingInfo requestMappingInfo = outerContext.getRequestMappingInfo();
        HandlerMethod handlerMethod = outerContext.getHandlerMethod();
        PatternsRequestCondition patternsCondition = requestMappingInfo.getPatternsCondition();
        ApiSelector selector = outerContext.getDocumentationContext().getApiSelector();
        ArrayList apiDescriptionList = Lists.newArrayList();
        for (String path : this.matchingPaths(selector, patternsCondition)) {
            String methodName = handlerMethod.getMethod().getName();
            RequestMappingContext operationContext = outerContext.copyPatternUsing(path);
            List<Operation> operations = this.operationReader.read(operationContext);
            ApiDescriptionBuilder descriptionBuilder = operationContext.apiDescriptionBuilder();
            descriptionBuilder.operations(operations);
            operationContext.apiDescriptionBuilder().operations(operations);
            operationContext.apiDescriptionBuilder().pathDecorator(this.pluginsManager.decorator(new PathContext(outerContext, FluentIterable.from(operations).first())));
            descriptionBuilder.path(path);
            descriptionBuilder.description(methodName);
            descriptionBuilder.hidden(false);
            apiDescriptionList.add(descriptionBuilder.build());
        }
        return apiDescriptionList;
    }

    private List<String> matchingPaths(ApiSelector selector, PatternsRequestCondition patternsCondition) {
        return Ordering.natural().sortedCopy((Iterable)FluentIterable.from((Iterable)patternsCondition.getPatterns()).filter(selector.getPathSelector()));
    }
}

