/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterMultiplesReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        Class parameterType = methodParameter.getParameterType();
        if (parameterType != null) {
            Boolean allowMultiple = parameterType.isArray() || Iterable.class.isAssignableFrom(parameterType);
            context.parameterBuilder().allowMultiple(allowMultiple.booleanValue());
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

