/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterRequiredReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        MethodParameter methodParameter = context.methodParameter();
        context.parameterBuilder().required(this.getAnnotatedRequired(methodParameter).booleanValue());
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private Boolean getAnnotatedRequired(MethodParameter methodParameter) {
        HashSet<Boolean> requiredSet = new HashSet<Boolean>();
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        boolean optional = this.isOptional(methodParameter);
        for (Annotation annotation : methodAnnotations) {
            if (annotation instanceof RequestParam) {
                requiredSet.add(!optional && ((RequestParam)annotation).required());
                continue;
            }
            if (annotation instanceof RequestHeader) {
                requiredSet.add(!optional && ((RequestHeader)annotation).required());
                continue;
            }
            if (!(annotation instanceof PathVariable)) continue;
            requiredSet.add(true);
        }
        return requiredSet.contains(true);
    }

    private boolean isOptional(MethodParameter methodParameter) {
        return methodParameter.getParameterType().getName().equals("java.util.Optional");
    }
}

