/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.Types;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.schema.AlternateTypeProvider;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeField;

@Component
public class ModelAttributeParameterExpander {
    private static final Logger LOG = LoggerFactory.getLogger(ModelAttributeParameterExpander.class);
    private final TypeResolver resolver;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ModelAttributeParameterExpander(TypeResolver resolver, DocumentationPluginsManager pluginsManager) {
        this.resolver = resolver;
        this.pluginsManager = pluginsManager;
    }

    public void expand(String parentName, Class<?> paramType, List<Parameter> parameters, DocumentationContext documentationContext) {
        Set<String> beanPropNames = this.getBeanPropertyNames(paramType);
        FluentIterable fields = FluentIterable.from(this.getInstanceFields(paramType)).filter(this.onlyBeanProperties(beanPropNames));
        LOG.debug("Expanding parameter type: {}", paramType);
        AlternateTypeProvider alternateTypeProvider = documentationContext.getAlternateTypeProvider();
        FluentIterable expendables = FluentIterable.from((Iterable)fields).transform(this.toModelAttributeField(alternateTypeProvider)).filter(Predicates.not(this.simpleType())).filter(Predicates.not(this.recursiveType(paramType)));
        for (ModelAttributeField each : expendables) {
            LOG.debug("Attempting to expand expandable field: {}", (Object)each.getField());
            this.expand(this.nestedParentName(parentName, each.getField()), each.getFieldType(), parameters, documentationContext);
        }
        FluentIterable simpleFields = FluentIterable.from((Iterable)fields).transform(this.toModelAttributeField(alternateTypeProvider)).filter(this.simpleType());
        for (ModelAttributeField each : simpleFields) {
            LOG.debug("Attempting to expand field: {}", (Object)each);
            String dataTypeName = (String)Optional.fromNullable((Object)Types.typeNameFor(each.getFieldType())).or((Object)each.getFieldType().getSimpleName());
            LOG.debug("Building parameter for field: {}, with type: ", (Object)each, each.getFieldType());
            ParameterExpansionContext parameterExpansionContext = new ParameterExpansionContext(dataTypeName, parentName, each.getField(), documentationContext.getDocumentationType(), new ParameterBuilder());
            parameters.add(this.pluginsManager.expandParameter(parameterExpansionContext));
        }
    }

    private Predicate<ModelAttributeField> recursiveType(final Class<?> paramType) {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return input.getFieldType() == paramType;
            }
        };
    }

    private Predicate<ModelAttributeField> simpleType() {
        return Predicates.or((Predicate)Predicates.or(this.belongsToJavaPackage(), (Predicate)Predicates.or(this.isCollection(), this.isMap())), this.isEnum());
    }

    private Predicate<ModelAttributeField> isCollection() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Collection.class.isAssignableFrom(input.getFieldType());
            }
        };
    }

    private Predicate<ModelAttributeField> isMap() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return Map.class.isAssignableFrom(input.getFieldType());
            }
        };
    }

    private Predicate<ModelAttributeField> isEnum() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return input.getFieldType().isEnum();
            }
        };
    }

    private Predicate<ModelAttributeField> belongsToJavaPackage() {
        return new Predicate<ModelAttributeField>(){

            public boolean apply(ModelAttributeField input) {
                return ModelAttributeParameterExpander.this.packageName(input.getFieldType()).startsWith("java");
            }
        };
    }

    private Function<Field, ModelAttributeField> toModelAttributeField(final AlternateTypeProvider alternateTypeProvider) {
        return new Function<Field, ModelAttributeField>(){

            public ModelAttributeField apply(Field input) {
                return new ModelAttributeField(ModelAttributeParameterExpander.this.fieldType(alternateTypeProvider, input), input);
            }
        };
    }

    private Predicate<Field> onlyBeanProperties(final Set<String> beanPropNames) {
        return new Predicate<Field>(){

            public boolean apply(Field input) {
                return beanPropNames.contains(input.getName());
            }
        };
    }

    private String nestedParentName(String parentName, Field field) {
        if (Strings.isNullOrEmpty((String)parentName)) {
            return field.getName();
        }
        return String.format("%s.%s", parentName, field.getName());
    }

    private Class<?> fieldType(AlternateTypeProvider alternateTypeProvider, Field field) {
        ResolvedType resolvedType;
        ResolvedType alternativeType;
        Class erasedType;
        Class<?> type = field.getType();
        if (type != (erasedType = (alternativeType = alternateTypeProvider.alternateFor(resolvedType = this.resolver.resolve(type, new Type[0]))).getErasedType())) {
            LOG.debug("Found alternative type [{}] for field: [{}-{}]", new Object[]{erasedType, field, type});
        }
        return erasedType;
    }

    private String packageName(Class<?> type) {
        return (String)Optional.fromNullable((Object)type.getPackage()).transform(this.toPackageName()).or((Object)"java");
    }

    private Function<Package, String> toPackageName() {
        return new Function<Package, String>(){

            public String apply(Package input) {
                return input.getName();
            }
        };
    }

    private List<Field> getInstanceFields(Class<?> type) {
        ArrayList<Field> result = new ArrayList<Field>();
        Class<?> i = type;
        while (!this.rootType(i)) {
            result.addAll(Arrays.asList(i.getDeclaredFields()));
            i = i.getSuperclass();
        }
        return FluentIterable.from(result).filter(Predicates.not(this.staticField())).filter(Predicates.not(this.syntheticFields())).toList();
    }

    private Predicate<Field> syntheticFields() {
        return new Predicate<Field>(){

            public boolean apply(Field input) {
                return input.isSynthetic();
            }
        };
    }

    private Predicate<Field> staticField() {
        return new Predicate<Field>(){

            public boolean apply(Field input) {
                return Modifier.isStatic(input.getModifiers());
            }
        };
    }

    private boolean rootType(Class clazz) {
        return Optional.fromNullable((Object)clazz).or(Object.class) == Object.class;
    }

    private Set<String> getBeanPropertyNames(Class<?> clazz) {
        try {
            PropertyDescriptor[] propDescriptors;
            HashSet<String> beanProps = new HashSet<String>();
            for (PropertyDescriptor propDescriptor : propDescriptors = this.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (propDescriptor.getReadMethod() == null || propDescriptor.getWriteMethod() == null) continue;
                beanProps.add(propDescriptor.getName());
            }
            return beanProps;
        }
        catch (IntrospectionException e) {
            LOG.warn(String.format("Failed to get bean properties on (%s)", clazz), (Throwable)e);
            return Sets.newHashSet();
        }
    }

    @VisibleForTesting
    BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz);
    }
}

