/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spi.service.contexts.OperationContext;

@Component
@Order(value=-2147483648)
public class OperationTagsReader
implements OperationBuilderPlugin {
    private final ResourceGroupingStrategy groupingStrategy;

    @Autowired
    public OperationTagsReader(ResourceGroupingStrategy groupingStrategy) {
        this.groupingStrategy = groupingStrategy;
    }

    public void apply(OperationContext context) {
        Set resourceGroups = this.groupingStrategy.getResourceGroups(context.getRequestMappingInfo(), context.getHandlerMethod());
        FluentIterable tags = FluentIterable.from((Iterable)resourceGroups).transform(this.toTags());
        context.operationBuilder().tags((Set)tags.toSet());
    }

    private Function<ResourceGroup, String> toTags() {
        return new Function<ResourceGroup, String>(){

            public String apply(ResourceGroup input) {
                return input.getGroupName();
            }
        };
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

