/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.DefaultsProviderPlugin;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.ResourceGroupingStrategy;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.SpringGroupingStrategy;
import springfox.documentation.spring.web.plugins.DefaultConfiguration;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.DuplicateGroupsDetector;

@Component
public class DocumentationPluginsManager {
    private final PluginRegistry<DocumentationPlugin, DocumentationType> documentationPlugins;
    private final PluginRegistry<ApiListingBuilderPlugin, DocumentationType> apiListingPlugins;
    private final PluginRegistry<ParameterBuilderPlugin, DocumentationType> parameterPlugins;
    private final PluginRegistry<ExpandedParameterBuilderPlugin, DocumentationType> parameterExpanderPlugins;
    private final PluginRegistry<OperationBuilderPlugin, DocumentationType> operationBuilderPlugins;
    private final PluginRegistry<ResourceGroupingStrategy, DocumentationType> resourceGroupingStrategies;
    private final PluginRegistry<OperationModelsProviderPlugin, DocumentationType> operationModelsProviders;
    private final PluginRegistry<DefaultsProviderPlugin, DocumentationType> defaultsProviders;

    @Autowired
    public DocumentationPluginsManager(@Qualifier(value="documentationPluginRegistry") PluginRegistry<DocumentationPlugin, DocumentationType> documentationPlugins, @Qualifier(value="apiListingBuilderPluginRegistry") PluginRegistry<ApiListingBuilderPlugin, DocumentationType> apiListingPlugins, @Qualifier(value="parameterBuilderPluginRegistry") PluginRegistry<ParameterBuilderPlugin, DocumentationType> parameterPlugins, @Qualifier(value="expandedParameterBuilderPluginRegistry") PluginRegistry<ExpandedParameterBuilderPlugin, DocumentationType> parameterExpanderPlugins, @Qualifier(value="operationBuilderPluginRegistry") PluginRegistry<OperationBuilderPlugin, DocumentationType> operationBuilderPlugins, @Qualifier(value="resourceGroupingStrategyRegistry") PluginRegistry<ResourceGroupingStrategy, DocumentationType> resourceGroupingStrategies, @Qualifier(value="operationModelsProviderPluginRegistry") PluginRegistry<OperationModelsProviderPlugin, DocumentationType> operationModelsProviders, @Qualifier(value="defaultsProviderPluginRegistry") PluginRegistry<DefaultsProviderPlugin, DocumentationType> defaultsProviders) {
        this.documentationPlugins = documentationPlugins;
        this.apiListingPlugins = apiListingPlugins;
        this.parameterPlugins = parameterPlugins;
        this.parameterExpanderPlugins = parameterExpanderPlugins;
        this.operationBuilderPlugins = operationBuilderPlugins;
        this.resourceGroupingStrategies = resourceGroupingStrategies;
        this.operationModelsProviders = operationModelsProviders;
        this.defaultsProviders = defaultsProviders;
    }

    public Iterable<DocumentationPlugin> documentationPlugins() throws IllegalStateException {
        List plugins = this.documentationPlugins.getPlugins();
        DuplicateGroupsDetector.ensureNoDuplicateGroups(plugins);
        if (plugins.isEmpty()) {
            return Lists.newArrayList((Object[])new DocumentationPlugin[]{this.defaultDocumentationPlugin()});
        }
        return plugins;
    }

    public Parameter parameter(ParameterContext parameterContext) {
        for (ParameterBuilderPlugin each : this.parameterPlugins.getPluginsFor((Object)parameterContext.getDocumentationType())) {
            each.apply(parameterContext);
        }
        return parameterContext.parameterBuilder().build();
    }

    public Parameter expandParameter(ParameterExpansionContext context) {
        for (ExpandedParameterBuilderPlugin each : this.parameterExpanderPlugins.getPluginsFor((Object)context.getDocumentationType())) {
            each.apply(context);
        }
        return context.getParameterBuilder().build();
    }

    public Operation operation(OperationContext operationContext) {
        for (OperationBuilderPlugin each : this.operationBuilderPlugins.getPluginsFor((Object)operationContext.getDocumentationType())) {
            each.apply(operationContext);
        }
        return operationContext.operationBuilder().build();
    }

    public ApiListing apiListing(ApiListingContext context) {
        for (ApiListingBuilderPlugin each : this.apiListingPlugins.getPluginsFor((Object)context.getDocumentationType())) {
            each.apply(context);
        }
        return context.apiListingBuilder().build();
    }

    public Set<ModelContext> modelContexts(RequestMappingContext context) {
        DocumentationType documentationType = context.getDocumentationContext().getDocumentationType();
        for (OperationModelsProviderPlugin each : this.operationModelsProviders.getPluginsFor((Object)documentationType)) {
            each.apply(context);
        }
        return context.operationModelsBuilder().build();
    }

    public ResourceGroupingStrategy resourceGroupingStrategy(DocumentationType documentationType) {
        return (ResourceGroupingStrategy)this.resourceGroupingStrategies.getPluginFor((Object)documentationType, (Plugin)new SpringGroupingStrategy());
    }

    private DocumentationPlugin defaultDocumentationPlugin() {
        return new Docket(DocumentationType.SWAGGER_12);
    }

    public DocumentationContextBuilder createContextBuilder(DocumentationType documentationType, DefaultConfiguration defaultConfiguration) {
        return ((DefaultsProviderPlugin)this.defaultsProviders.getPluginFor((Object)documentationType, (Plugin)defaultConfiguration)).create(documentationType).withResourceGroupingStrategy(this.resourceGroupingStrategy(documentationType));
    }
}

