/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Currency;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;

public class Types {
    private static final Set<String> baseTypes = Sets.newHashSet((Object[])new String[]{"int", "date", "string", "double", "float", "boolean", "byte", "object", "long", "date-time", "file", "biginteger", "bigdecimal"});
    private static final Map<Type, String> typeNameLookup = ImmutableMap.builder().put(Long.TYPE, (Object)"long").put(Short.TYPE, (Object)"int").put(Integer.TYPE, (Object)"int").put(Double.TYPE, (Object)"double").put(Float.TYPE, (Object)"float").put(Byte.TYPE, (Object)"byte").put(Boolean.TYPE, (Object)"boolean").put(Character.TYPE, (Object)"string").put(java.util.Date.class, (Object)"date-time").put(Date.class, (Object)"date").put(String.class, (Object)"string").put(Object.class, (Object)"object").put(Long.class, (Object)"long").put(Integer.class, (Object)"int").put(Short.class, (Object)"int").put(Double.class, (Object)"double").put(Float.class, (Object)"float").put(Boolean.class, (Object)"boolean").put(Byte.class, (Object)"byte").put(BigDecimal.class, (Object)"bigdecimal").put(BigInteger.class, (Object)"biginteger").put(Currency.class, (Object)"string").put(UUID.class, (Object)"string").put(MultipartFile.class, (Object)"file").build();

    private Types() {
        throw new UnsupportedOperationException();
    }

    public static String typeNameFor(Type type) {
        return typeNameLookup.get(type);
    }

    public static boolean isBaseType(String typeName) {
        return baseTypes.contains(typeName);
    }

    public static boolean isBaseType(ResolvedType type) {
        return baseTypes.contains(Types.typeNameFor(type.getErasedType()));
    }

    public static boolean isVoid(ResolvedType returnType) {
        return Void.class.equals((Object)returnType.getErasedType()) || Void.TYPE.equals(returnType.getErasedType());
    }
}

