/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.types.ResolvedArrayType;
import com.fasterxml.classmate.types.ResolvedPrimitiveType;
import com.google.common.base.Function;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Enums;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class ResolvedTypes {
    private ResolvedTypes() {
        throw new UnsupportedOperationException();
    }

    public static String simpleQualifiedTypeName(ResolvedType type) {
        if (type instanceof ResolvedPrimitiveType) {
            Class primitiveType = type.getErasedType();
            return Types.typeNameFor(primitiveType);
        }
        if (type instanceof ResolvedArrayType) {
            return Types.typeNameFor(type.getArrayElementType().getErasedType());
        }
        return type.getErasedType().getName();
    }

    public static AllowableValues allowableValues(ResolvedType resolvedType) {
        return Enums.allowableValues((Class)resolvedType.getErasedType());
    }

    public static Function<? super ResolvedType, ModelRef> modelRefFactory(final ModelContext parentContext, final TypeNameExtractor typeNameExtractor) {
        return new Function<ResolvedType, ModelRef>(){

            public ModelRef apply(ResolvedType type) {
                if (Collections.isContainerType(type)) {
                    ResolvedType collectionElementType = Collections.collectionElementType(type);
                    String elementTypeName = typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)parentContext, (ResolvedType)collectionElementType));
                    return new ModelRef(Collections.containerType(type), elementTypeName);
                }
                if (Maps.isMapType(type)) {
                    String elementTypeName = typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)parentContext, (ResolvedType)Maps.mapValueType(type)));
                    return new ModelRef("Map", elementTypeName, true);
                }
                String typeName = typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)parentContext, (ResolvedType)type));
                return new ModelRef(typeName);
            }
        };
    }
}

