/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.provider.ModelPropertiesProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
public class DefaultModelProvider
implements ModelProvider {
    private final TypeResolver resolver;
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;

    @Autowired
    public DefaultModelProvider(TypeResolver resolver, @Qualifier(value="default") ModelPropertiesProvider propertiesProvider, ModelDependencyProvider dependencyProvider, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.resolver = resolver;
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        ResolvedType propertiesHost = modelContext.alternateFor(modelContext.resolvedType(this.resolver));
        if (Collections.isContainerType(propertiesHost) || Maps.isMapType(propertiesHost) || propertiesHost.getErasedType().isEnum() || Types.isBaseType(Types.typeNameFor(propertiesHost.getErasedType())) || modelContext.hasSeenBefore(propertiesHost)) {
            return Optional.absent();
        }
        TreeMap properties = com.google.common.collect.Maps.newTreeMap();
        properties.putAll(com.google.common.collect.Maps.uniqueIndex(this.properties(modelContext, propertiesHost), this.byPropertyName()));
        return Optional.of((Object)this.modelBuilder(propertiesHost, properties, modelContext));
    }

    private Model modelBuilder(ResolvedType propertiesHost, Map<String, ModelProperty> properties, ModelContext modelContext) {
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)propertiesHost));
        modelContext.getBuilder().id(typeName).type(propertiesHost).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(propertiesHost)).properties(properties).description("").baseModel("").discriminator("").subTypes(new ArrayList());
        return this.schemaPluginsManager.model(modelContext);
    }

    @Override
    public Map<String, Model> dependencies(ModelContext modelContext) {
        HashMap models = com.google.common.collect.Maps.newHashMap();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            Optional<Model> model = this.modelFor(ModelContext.fromParent((ModelContext)modelContext, (ResolvedType)resolvedType));
            if (!model.isPresent()) continue;
            models.put(((Model)model.get()).getName(), model.get());
        }
        return models;
    }

    private Function<ModelProperty, String> byPropertyName() {
        return new Function<ModelProperty, String>(){

            public String apply(ModelProperty input) {
                return input.getName();
            }
        };
    }

    private List<ModelProperty> properties(ModelContext context, ResolvedType propertiesHost) {
        return this.propertiesProvider.propertiesFor(propertiesHost, context);
    }
}

