/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.hateoas.Resources;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandler;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.data.rest.EntityOperationsExtractor;
import springfox.documentation.spring.data.rest.Java8OptionalToGuavaOptionalConverter;
import springfox.documentation.spring.data.rest.RequestExtractionUtils;
import springfox.documentation.spring.data.rest.SpringDataRestRequestHandler;

class EntityFindAllExtractor
implements EntityOperationsExtractor {
    EntityFindAllExtractor() {
    }

    @Override
    public List<RequestHandler> extract(EntityContext context) {
        ArrayList handlers = Lists.newArrayList();
        PersistentEntity<?, ?> entity = context.entity();
        CrudMethods crudMethods = context.crudMethods();
        TypeResolver resolver = context.getTypeResolver();
        RepositoryMetadata repository = context.getRepositoryMetadata();
        Method getFindAllMethod = crudMethods.getFindAllMethod();
        if (crudMethods.hasFindAllMethod()) {
            Java8OptionalToGuavaOptionalConverter converter = new Java8OptionalToGuavaOptionalConverter();
            Method actualFindAllMethod = (Method)converter.convert(getFindAllMethod).orNull();
            HandlerMethod handler = new HandlerMethod(context.getRepositoryInstance(), actualFindAllMethod);
            ActionSpecification spec = new ActionSpecification(RequestExtractionUtils.actionName(entity, actualFindAllMethod), String.format("%s%s", context.basePath(), context.resourcePath()), Sets.newHashSet((Object[])new RequestMethod[]{RequestMethod.GET}), Sets.newHashSet((Object[])new MediaType[]{MediaType.APPLICATION_JSON, RestMediaTypes.HAL_JSON, RestMediaTypes.SPRING_DATA_COMPACT_JSON, RestMediaTypes.TEXT_URI_LIST}), new HashSet<MediaType>(), handler, this.findAllParameters(context.getConfiguration(), context.getTypeResolver()), resolver.resolve(Resources.class, new Type[]{repository.getReturnedDomainClass(handler.getMethod())}));
            handlers.add(new SpringDataRestRequestHandler(context, spec));
        }
        return handlers;
    }

    private ArrayList<ResolvedMethodParameter> findAllParameters(RepositoryRestConfiguration configuration, TypeResolver resolver) {
        ArrayList<ResolvedMethodParameter> parameters = new ArrayList<ResolvedMethodParameter>();
        parameters.add(new ResolvedMethodParameter(0, configuration.getPageParamName(), (List)Lists.newArrayList(), resolver.resolve(String.class, new Type[0])));
        parameters.add(new ResolvedMethodParameter(1, configuration.getLimitParamName(), (List)Lists.newArrayList(), resolver.resolve(String.class, new Type[0])));
        parameters.add(new ResolvedMethodParameter(2, configuration.getSortParamName(), (List)Lists.newArrayList(), resolver.resolve(String.class, new Type[0])));
        return parameters;
    }
}

