/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.filter;

import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.Violation;
import java.lang.reflect.Field;
import java.util.Objects;

public class RequiresOuterThisFilter
implements TreeWalkerFilter {
    private static final Field ARGS_FIELD = RequiresOuterThisFilter.getArgsField();

    public boolean accept(TreeWalkerAuditEvent event) {
        Violation violation = event.getViolation();
        if ("require.this.variable".equals(violation.getKey())) {
            String prefex;
            Object[] args = this.getArgs(violation);
            String string = prefex = args.length > 1 ? Objects.toString(args[1]) : null;
            if (prefex != null && prefex.length() > 0) {
                return false;
            }
        }
        return true;
    }

    private Object[] getArgs(Violation violation) {
        if (ARGS_FIELD == null) {
            throw new IllegalStateException("Unable to extract message args");
        }
        try {
            return (Object[])ARGS_FIELD.get(violation);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static Field getArgsField() {
        try {
            Field field = Violation.class.getDeclaredField("args");
            field.setAccessible(true);
            return field;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

