/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.GetNextReleaseMilestoneTask;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;

public abstract class ScheduleNextReleaseTask
extends DefaultTask {
    public static final String TASK_NAME = "scheduleNextRelease";

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getGitHubAccessToken();

    @Input
    public abstract Property<String> getVersion();

    @Input
    public abstract Property<Integer> getWeekOfMonth();

    @Input
    public abstract Property<Integer> getDayOfWeek();

    @TaskAction
    public void scheduleNextRelease() {
        Repository repository = (Repository)this.getRepository().get();
        String gitHubAccessToken = (String)this.getGitHubAccessToken().get();
        String version = (String)this.getVersion().get();
        Integer weekOfMonth = (Integer)this.getWeekOfMonth().get();
        Integer dayOfWeek = (Integer)this.getDayOfWeek().get();
        SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
        springReleases.scheduleReleaseIfNotExists(repository.owner(), repository.name(), version, weekOfMonth, dayOfWeek);
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + String.valueOf(SpringReleasePluginExtension.class));
        project.getTasks().register(TASK_NAME, ScheduleNextReleaseTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Schedule the next release (even months only) or release train (series of milestones starting in January or July) based on the current version");
            task.doNotTrackState("API call to GitHub needs to check for new milestones every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "nextVersion").orElse(ProjectUtils.findTaskByType(project, GetNextReleaseMilestoneTask.class).getNextReleaseMilestoneFile().map(RegularFileUtils::readString));
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = (String)springRelease.getRepositoryName().get();
            task.getRepository().set((Object)new Repository(owner, name));
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            task.getVersion().set(versionProvider);
            task.getWeekOfMonth().set(springRelease.getWeekOfMonth());
            task.getDayOfWeek().set(springRelease.getDayOfWeek());
        });
    }
}

