/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.Repository;
import groovy.lang.MissingPropertyException;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import io.spring.gradle.plugin.release.GenerateChangelogTask;
import io.spring.gradle.plugin.release.GetNextReleaseMilestoneTask;
import io.spring.gradle.plugin.release.SpringReleasePluginExtension;
import io.spring.release.SpringReleases;
import java.util.Objects;
import java.util.regex.Matcher;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class CreateReleaseTask
extends DefaultTask {
    public static final String TASK_NAME = "createRelease";

    @Input
    public abstract Property<Repository> getRepository();

    @Input
    public abstract Property<String> getVersion();

    @Input
    public abstract Property<String> getReleaseNotes();

    @Input
    public abstract Property<String> getBranch();

    @Input
    public abstract Property<String> getReferenceDocUrl();

    @Input
    public abstract Property<String> getApiDocUrl();

    @Input
    public abstract Property<Boolean> getCreateRelease();

    @Input
    @Optional
    @Deprecated
    public abstract Property<Boolean> getReplaceSnapshotVersionInReferenceDocUrl();

    @Input
    public abstract Property<Boolean> getReplaceVersionInReferenceDocUrl();

    @Input
    @Optional
    public abstract Property<String> getGitHubAccessToken();

    @TaskAction
    public void createRelease() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().getOrNull();
        Repository repository = (Repository)this.getRepository().get();
        String version = (String)this.getVersion().get();
        String branch = (String)this.getBranch().get();
        String body = (String)this.getReleaseNotes().get();
        String referenceDocUrl = (String)this.getReferenceDocUrl().get();
        String apiDocUrl = (String)this.getApiDocUrl().get();
        Boolean createRelease = (Boolean)this.getCreateRelease().get();
        if (createRelease.booleanValue() && gitHubAccessToken == null) {
            throw new MissingPropertyException("Please provide an access token with -PgitHubAccessToken=...");
        }
        Boolean replaceVersion = (Boolean)this.getReplaceVersionInReferenceDocUrl().get();
        Boolean replaceSnapshotVersion = (Boolean)this.getReplaceSnapshotVersionInReferenceDocUrl().getOrNull();
        if (replaceSnapshotVersion != null) {
            replaceVersion = replaceSnapshotVersion;
        }
        if (replaceVersion.booleanValue()) {
            Matcher versionMatcher = SpringReleases.versionMatcher(version);
            String majorVersion = versionMatcher.group(1);
            String minorVersion = versionMatcher.group(2);
            String majorMinorVersion = version.endsWith("-SNAPSHOT") ? "%s.%s-SNAPSHOT".formatted(majorVersion, minorVersion) : "%s.%s".formatted(majorVersion, minorVersion);
            referenceDocUrl = referenceDocUrl.replace("{version}", majorMinorVersion);
        }
        System.out.printf("%sCreating release for %s/%s@%s%n", createRelease != false ? "" : "[DRY RUN] ", repository.owner(), repository.name(), version);
        System.out.printf("%nRelease Notes:%n%n----%n%s%n----%n%n", body.trim());
        System.out.printf("%nreferenceDocUrl=%s%napiDocUrl=%s%n", referenceDocUrl, apiDocUrl);
        if (createRelease.booleanValue()) {
            SpringReleases springReleases = new SpringReleases(gitHubAccessToken);
            springReleases.createRelease(repository.owner(), repository.name(), version, branch, body, referenceDocUrl, apiDocUrl);
        }
    }

    public static void register(Project project) {
        SpringReleasePluginExtension springRelease = (SpringReleasePluginExtension)project.getExtensions().findByType(SpringReleasePluginExtension.class);
        Objects.requireNonNull(springRelease, "Cannot find " + String.valueOf(SpringReleasePluginExtension.class));
        project.getTasks().register(TASK_NAME, CreateReleaseTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Create a GitHub release with release notes");
            task.doNotTrackState("API call to GitHub needs to check for new issues and create a release every time");
            Provider versionProvider = ProjectUtils.getProperty(project, "nextVersion").orElse(ProjectUtils.findTaskByType(project, GetNextReleaseMilestoneTask.class).getNextReleaseMilestoneFile().map(RegularFileUtils::readString));
            Provider releaseNotesProvider = ProjectUtils.findTaskByType(project, GenerateChangelogTask.class).getReleaseNotesFile().map(RegularFileUtils::readString);
            Provider createReleaseProvider = ProjectUtils.getProperty(project, TASK_NAME).map(Boolean::valueOf);
            String owner = (String)springRelease.getRepositoryOwner().get();
            String name = project.getRootProject().getName();
            task.getRepository().set((Object)new Repository(owner, name));
            task.getVersion().set(versionProvider);
            task.getReleaseNotes().set(releaseNotesProvider);
            task.getBranch().set(ProjectUtils.getProperty(project, "branch").orElse((Object)"main"));
            task.getReferenceDocUrl().set(springRelease.getReferenceDocUrl());
            task.getApiDocUrl().set(springRelease.getApiDocUrl());
            task.getReplaceSnapshotVersionInReferenceDocUrl().set(springRelease.getReplaceSnapshotVersionInReferenceDocUrl());
            task.getReplaceVersionInReferenceDocUrl().set(springRelease.getReplaceVersionInReferenceDocUrl());
            task.getCreateRelease().set(createReleaseProvider.orElse((Object)false));
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
        });
    }
}

