/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.plugin.release;

import com.github.api.GitHubApi;
import com.github.api.User;
import io.spring.gradle.plugin.core.ProjectUtils;
import io.spring.gradle.plugin.core.RegularFileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class GetGitHubUserNameTask
extends DefaultTask {
    public static final String TASK_NAME = "getGitHubUserName";

    @Input
    public abstract Property<String> getGitHubAccessToken();

    @OutputFile
    public abstract RegularFileProperty getUsernameFile();

    @TaskAction
    public void getGitHubUsername() {
        String gitHubAccessToken = (String)this.getGitHubAccessToken().get();
        GitHubApi github = new GitHubApi(gitHubAccessToken);
        User user = github.getUser();
        if (user == null) {
            throw new IllegalStateException("Unable to retrieve GitHub username. Please check the personal access token and try again.");
        }
        RegularFileUtils.writeString((RegularFile)this.getUsernameFile().get(), user.login());
        System.out.println(user.login());
    }

    public static void register(Project project) {
        project.getTasks().register(TASK_NAME, GetGitHubUserNameTask.class, task -> {
            task.setGroup("Release");
            task.setDescription("Use gitHubAccessToken to automatically set username property.");
            task.getGitHubAccessToken().set(ProjectUtils.getProperty(project, "gitHubAccessToken"));
            task.getUsernameFile().set(project.getLayout().getBuildDirectory().file("github-username.txt"));
        });
    }
}

