/*
 * Decompiled with CFR 0.152.
 */
package io.spring.api;

import java.util.regex.Pattern;

public record Release(String version, String referenceDocUrl, String apiDocUrl, ReleaseStatus status, boolean current) {

    public static enum ReleaseStatus {
        SNAPSHOT,
        PRERELEASE,
        GENERAL_AVAILABILITY;

        private static final Pattern PRERELEASE_PATTERN;
        private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";

        public static ReleaseStatus parse(String version) {
            if (version == null) {
                throw new IllegalArgumentException("version cannot be null");
            }
            if (version.endsWith(SNAPSHOT_SUFFIX)) {
                return SNAPSHOT;
            }
            if (PRERELEASE_PATTERN.matcher(version).matches()) {
                return PRERELEASE;
            }
            return GENERAL_AVAILABILITY;
        }

        static {
            PRERELEASE_PATTERN = Pattern.compile("[A-Za-z0-9.\\-]+?(M|RC)\\d+");
        }
    }
}

