/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import io.specto.hoverfly.junit.core.model.ArrayMatcherConfig;
import io.specto.hoverfly.junit.core.model.MatcherConfig;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RequestFieldMatcher<T> {
    private MatcherType matcher;
    private T value;
    private MatcherConfig config;
    private RequestFieldMatcher<?> doMatch;

    public RequestFieldMatcher() {
    }

    public RequestFieldMatcher(MatcherType matcher, T value) {
        this.matcher = matcher;
        this.value = value;
    }

    public RequestFieldMatcher(MatcherType matcher, T value, MatcherConfig config) {
        this.matcher = matcher;
        this.value = value;
        this.config = config;
    }

    public MatcherType getMatcher() {
        return this.matcher;
    }

    public void setMatcher(MatcherType matcher) {
        this.matcher = matcher;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public MatcherConfig getConfig() {
        return this.config;
    }

    public void setConfig(MatcherConfig config) {
        this.config = config;
    }

    public RequestFieldMatcher<?> getDoMatch() {
        return this.doMatch;
    }

    public void setDoMatch(RequestFieldMatcher<?> doMatch) {
        this.doMatch = doMatch;
    }

    public static RequestFieldMatcher<String> newExactMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.EXACT, value);
    }

    public static RequestFieldMatcher<String> newGlobMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.GLOB, value);
    }

    public static RequestFieldMatcher<String> newRegexMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.REGEX, value);
    }

    public static RequestFieldMatcher<List<String>> newArrayMatcher(List<String> value) {
        return new RequestFieldMatcher<List<String>>(MatcherType.ARRAY, value);
    }

    public static RequestFieldMatcher<List<String>> newArrayMatcher(List<String> value, ArrayMatcherConfig arrayMatcherConfig) {
        return new RequestFieldMatcher<List<String>>(MatcherType.ARRAY, value, arrayMatcherConfig);
    }

    public static RequestFieldMatcher<Map<String, List<RequestFieldMatcher<?>>>> newFormMatcher(Map<String, List<RequestFieldMatcher<?>>> value) {
        return new RequestFieldMatcher(MatcherType.FORM, value);
    }

    public static RequestFieldMatcher<String> newJwtMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JWT, value);
    }

    public static RequestFieldMatcher<String> newXmlMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.XML, value);
    }

    public static RequestFieldMatcher<String> newXpathMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.XPATH, value);
    }

    public static RequestFieldMatcher<String> newJsonMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JSON, value);
    }

    public static RequestFieldMatcher<String> newJsonPartialMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JSONPARTIAL, value);
    }

    public static RequestFieldMatcher<String> newJsonPathMatch(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JSONPATH, value);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum MatcherType {
        EXACT,
        GLOB,
        REGEX,
        ARRAY,
        JWT,
        FORM,
        XML,
        XPATH,
        JSON,
        JSONPARTIAL,
        JSONPATH;


        @JsonCreator
        public static MatcherType fromValue(String value) {
            return value == null ? null : MatcherType.valueOf(value.toUpperCase());
        }

        @JsonValue
        public String getValue() {
            return this.name().toLowerCase();
        }
    }

    public static class MatcherChainingBuilder {
        private final RequestFieldMatcher<?> rootMatcher;
        private RequestFieldMatcher<?> currentMatcher;

        private MatcherChainingBuilder(RequestFieldMatcher<?> rootMatcher) {
            this.rootMatcher = rootMatcher;
            this.currentMatcher = rootMatcher;
        }

        public static MatcherChainingBuilder root(RequestFieldMatcher<?> matcher) {
            return new MatcherChainingBuilder(matcher);
        }

        public MatcherChainingBuilder next(RequestFieldMatcher<?> matcher) {
            this.currentMatcher.setDoMatch(matcher);
            this.currentMatcher = matcher;
            return this;
        }

        public RequestFieldMatcher<?> build() {
            return this.rootMatcher;
        }
    }
}

