/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.SimulationPreprocessor;
import io.specto.hoverfly.junit.core.config.LocalMiddleware;
import io.specto.hoverfly.junit.core.config.LogLevel;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;

public class HoverflyConfiguration {
    private String scheme = "http";
    private String host = "localhost";
    private int proxyPort;
    private int adminPort;
    private boolean proxyLocalHost;
    private String destination;
    private String sslCertificatePath;
    private String sslKeyPath;
    private String authToken;
    private boolean isRemoteInstance;
    private String adminCertificate;
    private String proxyCaCertificate;
    private LocalMiddleware localMiddleware;
    private List<String> captureHeaders;
    private boolean webServer;
    private boolean tlsVerificationDisabled;
    private boolean plainHttpTunneling;
    private String upstreamProxy;
    private Logger hoverflyLogger;
    private LogLevel logLevel;
    private boolean statefulCapture;
    private boolean incrementalCapture;
    private SimulationPreprocessor simulationPreprocessor;
    private String binaryNameFormat;
    private List<String> commands;
    private String binaryLocation;
    private String clientCertPath;
    private String clientKeyPath;
    private String clientAuthDestination;
    private String clientCaCertPath;
    private String responseBodyFilesPath;
    private boolean isRelativeResponseBodyFilesPath;
    private Duration healthCheckTimeout;
    private Duration healthCheckRetryInterval;

    HoverflyConfiguration(String scheme, String host, int proxyPort, int adminPort, boolean proxyLocalHost, String destination, String proxyCaCertificate, String authToken, String adminCertificate, List<String> captureHeaders, boolean webServer, boolean statefulCapture, boolean incrementalCapture, SimulationPreprocessor preprocessor) {
        this(proxyPort, adminPort, proxyLocalHost, destination, proxyCaCertificate, captureHeaders, webServer, null, null, statefulCapture, incrementalCapture, preprocessor);
        this.setScheme(scheme);
        this.setHost(host);
        this.authToken = authToken;
        this.adminCertificate = adminCertificate;
        this.isRemoteInstance = true;
    }

    public HoverflyConfiguration(int proxyPort, int adminPort, boolean proxyLocalHost, String destination, String proxyCaCertificate, List<String> captureHeaders, boolean webServer, Logger hoverflyLogger, LogLevel logLevel, boolean statefulCapture, boolean incrementalCapture, SimulationPreprocessor preprocessor) {
        this.proxyPort = proxyPort;
        this.adminPort = adminPort;
        this.proxyLocalHost = proxyLocalHost;
        this.destination = destination;
        this.proxyCaCertificate = proxyCaCertificate;
        this.captureHeaders = captureHeaders;
        this.webServer = webServer;
        this.hoverflyLogger = hoverflyLogger;
        this.logLevel = logLevel;
        this.statefulCapture = statefulCapture;
        this.incrementalCapture = incrementalCapture;
        this.simulationPreprocessor = preprocessor;
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public boolean isProxyLocalHost() {
        return this.proxyLocalHost;
    }

    public String getSslCertificatePath() {
        return this.sslCertificatePath;
    }

    public String getSslKeyPath() {
        return this.sslKeyPath;
    }

    public void setSslCertificatePath(String sslCertificatePath) {
        this.sslCertificatePath = sslCertificatePath;
    }

    public void setSslKeyPath(String sslKeyPath) {
        this.sslKeyPath = sslKeyPath;
    }

    public String getDestination() {
        return this.destination;
    }

    public Optional<String> getAuthToken() {
        return Optional.ofNullable(this.authToken);
    }

    public boolean isRemoteInstance() {
        return this.isRemoteInstance;
    }

    public Optional<String> getProxyCaCertificate() {
        return Optional.ofNullable(this.proxyCaCertificate);
    }

    public String getAdminCertificate() {
        return this.adminCertificate;
    }

    public List<String> getCaptureHeaders() {
        return this.captureHeaders;
    }

    public String getUpstreamProxy() {
        return this.upstreamProxy;
    }

    public void setUpstreamProxy(String upstreamProxy) {
        this.upstreamProxy = upstreamProxy;
    }

    void setHost(String host) {
        if (host != null) {
            this.host = host;
        }
    }

    void setScheme(String scheme) {
        if (scheme != null) {
            this.scheme = scheme;
        }
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public boolean isWebServer() {
        return this.webServer;
    }

    public void setWebServer(boolean webServer) {
        this.webServer = webServer;
    }

    public boolean isTlsVerificationDisabled() {
        return this.tlsVerificationDisabled;
    }

    public void setTlsVerificationDisabled(boolean tlsVerificationDisabled) {
        this.tlsVerificationDisabled = tlsVerificationDisabled;
    }

    public boolean isPlainHttpTunneling() {
        return this.plainHttpTunneling;
    }

    public void setPlainHttpTunneling(boolean plainHttpTunneling) {
        this.plainHttpTunneling = plainHttpTunneling;
    }

    public LocalMiddleware getLocalMiddleware() {
        return this.localMiddleware;
    }

    public void setLocalMiddleware(LocalMiddleware localMiddleware) {
        this.localMiddleware = localMiddleware;
    }

    public boolean isMiddlewareEnabled() {
        return this.localMiddleware != null && this.isNotBlank(this.localMiddleware.getBinary()) && this.isNotBlank(this.localMiddleware.getPath());
    }

    public Optional<Logger> getHoverflyLogger() {
        return Optional.ofNullable(this.hoverflyLogger);
    }

    public Optional<LogLevel> getLogLevel() {
        return Optional.ofNullable(this.logLevel);
    }

    public boolean isStatefulCapture() {
        return this.statefulCapture;
    }

    public boolean isIncrementalCapture() {
        return this.incrementalCapture;
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    public void setSimulationPreprocessor(SimulationPreprocessor simulationPreprocessor) {
        this.simulationPreprocessor = simulationPreprocessor;
    }

    public Optional<SimulationPreprocessor> getSimulationPreprocessor() {
        return Optional.ofNullable(this.simulationPreprocessor);
    }

    public String getBinaryNameFormat() {
        return this.binaryNameFormat;
    }

    public void setBinaryNameFormat(String binaryNameFormat) {
        this.binaryNameFormat = binaryNameFormat;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> commands) {
        this.commands = commands;
    }

    public void setBinaryLocation(String binaryLocation) {
        this.binaryLocation = binaryLocation;
    }

    public String getBinaryLocation() {
        return this.binaryLocation;
    }

    public String getClientCertPath() {
        return this.clientCertPath;
    }

    public void setClientCertPath(String clientCertPath) {
        this.clientCertPath = clientCertPath;
    }

    public String getClientKeyPath() {
        return this.clientKeyPath;
    }

    public void setClientKeyPath(String clientKeyPath) {
        this.clientKeyPath = clientKeyPath;
    }

    public String getClientAuthDestination() {
        return this.clientAuthDestination;
    }

    public void setClientAuthDestination(String clientAuthDestination) {
        this.clientAuthDestination = clientAuthDestination;
    }

    public String getClientCaCertPath() {
        return this.clientCaCertPath;
    }

    public void setClientCaCertPath(String clientCaCertPath) {
        this.clientCaCertPath = clientCaCertPath;
    }

    public boolean isClientAuthEnabled() {
        return this.isNotBlank(this.clientCertPath) && this.isNotBlank(this.clientKeyPath) && this.isNotBlank(this.clientAuthDestination);
    }

    public String getResponseBodyFilesPath() {
        return this.responseBodyFilesPath;
    }

    public void setResponseBodyFilesPath(String responseBodyFilesPath) {
        this.responseBodyFilesPath = responseBodyFilesPath;
    }

    public boolean isRelativeResponseBodyFilesPath() {
        return this.isRelativeResponseBodyFilesPath;
    }

    public void setRelativeResponseBodyFilesPath(boolean relativeResponseBodyFilesPath) {
        this.isRelativeResponseBodyFilesPath = relativeResponseBodyFilesPath;
    }

    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public void setHealthCheckTimeout(Duration healthCheckTimeout) {
        this.healthCheckTimeout = healthCheckTimeout;
    }

    public Duration getHealthCheckRetryInterval() {
        return this.healthCheckRetryInterval;
    }

    public void setHealthCheckRetryInterval(Duration healthCheckRetryInterval) {
        this.healthCheckRetryInterval = healthCheckRetryInterval;
    }
}

