/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.sentry.core.DateUtils;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.lang.reflect.Type;
import java.util.Date;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DateDeserializerAdapter
implements JsonDeserializer<Date> {
    private final ILogger logger;

    public DateDeserializerAdapter(ILogger logger) {
        this.logger = logger;
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return json == null ? null : DateUtils.getDateTime((String)json.getAsString());
        }
        catch (Exception e) {
            ILogger.logIfNotNull((ILogger)this.logger, (SentryLevel)SentryLevel.ERROR, (String)"Error when deserializing Date", (Throwable)e);
            return null;
        }
    }
}

