/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.sentry.android.core.UnknownPropertiesTypeAdapterFactory;
import io.sentry.android.core.adapters.ContextsDeserializerAdapter;
import io.sentry.android.core.adapters.DateDeserializerAdapter;
import io.sentry.android.core.adapters.DateSerializerAdapter;
import io.sentry.android.core.adapters.OrientationDeserializerAdapter;
import io.sentry.android.core.adapters.OrientationSerializerAdapter;
import io.sentry.android.core.adapters.SentryIdDeserializerAdapter;
import io.sentry.android.core.adapters.SentryIdSerializerAdapter;
import io.sentry.android.core.adapters.SentryLevelDeserializerAdapter;
import io.sentry.android.core.adapters.SentryLevelSerializerAdapter;
import io.sentry.android.core.adapters.TimeZoneDeserializerAdapter;
import io.sentry.android.core.adapters.TimeZoneSerializerAdapter;
import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.protocol.Contexts;
import io.sentry.core.protocol.Device;
import io.sentry.core.protocol.SentryId;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.TimeZone;

final class AndroidSerializer
implements ISerializer {
    private final ILogger logger;
    private final Gson gson;

    public AndroidSerializer(ILogger logger) {
        this.logger = logger;
        this.gson = this.provideGson();
    }

    private Gson provideGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(SentryId.class, (Object)new SentryIdSerializerAdapter(this.logger)).registerTypeAdapter(SentryId.class, (Object)new SentryIdDeserializerAdapter(this.logger)).registerTypeAdapter(Date.class, (Object)new DateSerializerAdapter(this.logger)).registerTypeAdapter(Date.class, (Object)new DateDeserializerAdapter(this.logger)).registerTypeAdapter(TimeZone.class, (Object)new TimeZoneSerializerAdapter(this.logger)).registerTypeAdapter(TimeZone.class, (Object)new TimeZoneDeserializerAdapter(this.logger)).registerTypeAdapter(Device.DeviceOrientation.class, (Object)new OrientationSerializerAdapter(this.logger)).registerTypeAdapter(Device.DeviceOrientation.class, (Object)new OrientationDeserializerAdapter(this.logger)).registerTypeAdapter(SentryLevel.class, (Object)new SentryLevelSerializerAdapter(this.logger)).registerTypeAdapter(SentryLevel.class, (Object)new SentryLevelDeserializerAdapter(this.logger)).registerTypeAdapter(Contexts.class, (Object)new ContextsDeserializerAdapter(this.logger)).registerTypeAdapterFactory(UnknownPropertiesTypeAdapterFactory.get()).create();
    }

    public SentryEvent deserializeEvent(Reader eventReader) {
        return (SentryEvent)this.gson.fromJson(eventReader, SentryEvent.class);
    }

    public void serialize(SentryEvent event, Writer writer) throws IOException {
        this.gson.toJson((Object)event, SentryEvent.class, (Appendable)writer);
        writer.flush();
        writer.close();
    }
}

