/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.os.FileObserver;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import io.sentry.core.util.Objects;
import java.io.File;
import org.jetbrains.annotations.Nullable;

final class EnvelopeFileObserver
extends FileObserver {
    private String rootPath;
    private final IEnvelopeSender envelopeSender;
    private ILogger logger;

    EnvelopeFileObserver(String path, IEnvelopeSender envelopeSender, ILogger logger) {
        super(path);
        this.rootPath = (String)Objects.requireNonNull((Object)path, (String)"File path is required.");
        this.envelopeSender = (IEnvelopeSender)Objects.requireNonNull((Object)envelopeSender, (String)"Envelope sender is required.");
        this.logger = (ILogger)Objects.requireNonNull((Object)logger, (String)"Logger is required.");
    }

    public void onEvent(int eventType, @Nullable String relativePath) {
        if (relativePath == null) {
            return;
        }
        this.logger.log(SentryLevel.DEBUG, "onEvent fired for EnvelopeFileObserver with event type %d on path: %s for file %s.", new Object[]{eventType, this.rootPath, relativePath});
        this.envelopeSender.processEnvelopeFile(this.rootPath + File.separator + relativePath);
    }
}

