/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.webtestclient;

import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.http.Method;
import io.restassured.module.webtestclient.config.RestAssuredWebTestClientConfig;
import io.restassured.module.webtestclient.internal.BuilderBasedWebTestClientFactory;
import io.restassured.module.webtestclient.internal.StandaloneWebTestClientFactory;
import io.restassured.module.webtestclient.internal.WebTestClientFactory;
import io.restassured.module.webtestclient.internal.WebTestClientRequestSpecificationImpl;
import io.restassured.module.webtestclient.internal.WrapperWebTestClientFactory;
import io.restassured.module.webtestclient.response.WebTestClientResponse;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSender;
import io.restassured.module.webtestclient.specification.WebTestClientRequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.util.UriBuilder;

public class RestAssuredWebTestClient {
    public static RestAssuredWebTestClientConfig config;
    public static WebTestClientRequestSpecification requestSpecification;
    public static ResponseSpecification responseSpecification;
    public static String basePath;
    private static WebTestClientFactory webTestClientFactory;

    public static void webTestClient(WebTestClient webTestClient) {
        webTestClientFactory = new WrapperWebTestClientFactory(webTestClient);
    }

    public static WebTestClientRequestSpecification given() {
        return new WebTestClientRequestSpecificationImpl(webTestClientFactory, config, basePath, requestSpecification, responseSpecification);
    }

    public static WebTestClientRequestSpecification with() {
        return RestAssuredWebTestClient.given();
    }

    public static void standaloneSetup(Object ... controllersOrConfigurersOrExchangeFilterFunctions) {
        webTestClientFactory = StandaloneWebTestClientFactory.of(controllersOrConfigurersOrExchangeFilterFunctions);
    }

    public static void standaloneSetup(RouterFunction routerFunction, Object ... configurersOrExchangeFilterFunctions) {
        webTestClientFactory = StandaloneWebTestClientFactory.of(routerFunction, configurersOrExchangeFilterFunctions);
    }

    public static void standaloneSetup(WebTestClient.Builder builder) {
        webTestClientFactory = new BuilderBasedWebTestClientFactory(builder);
    }

    public static void webAppContextSetup(WebApplicationContext context, Object ... configurersOrExchangeFilterFunctions) {
        webTestClientFactory = StandaloneWebTestClientFactory.of((ApplicationContext)context, configurersOrExchangeFilterFunctions);
    }

    public static void applicationContextSetup(ApplicationContext context, Object ... configurersOrExchangeFilterFunctions) {
        webTestClientFactory = StandaloneWebTestClientFactory.of(context, configurersOrExchangeFilterFunctions);
    }

    public static void reset() {
        webTestClientFactory = null;
        config = null;
        basePath = "/";
        responseSpecification = null;
        requestSpecification = null;
    }

    public static WebTestClientResponse get(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().get(path, pathParams);
    }

    public static WebTestClientResponse get(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().get(path, pathParams);
    }

    public static WebTestClientResponse get(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().get(uriFunction);
    }

    public static WebTestClientResponse post(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().post(path, pathParams);
    }

    public static WebTestClientResponse get(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().get(uri);
    }

    public static WebTestClientResponse get(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().get(url);
    }

    public static WebTestClientResponse get() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().get();
    }

    public static WebTestClientResponse request(Method method) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method);
    }

    public static WebTestClientResponse request(String method) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method);
    }

    public static WebTestClientResponse request(Method method, String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method, path, pathParams);
    }

    public static WebTestClientResponse request(String method, String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method, path, pathParams);
    }

    public static WebTestClientResponse request(Method method, URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method, uri);
    }

    public static WebTestClientResponse request(Method method, Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().request(method, uriFunction);
    }

    public static WebTestClientResponse request(Method method, URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method, url);
    }

    public static WebTestClientResponse request(String method, URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method, uri);
    }

    public static WebTestClientResponse request(String method, Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().request(method, uriFunction);
    }

    public static WebTestClientResponse request(String method, URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().request(method, url);
    }

    public static WebTestClientResponse post(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().post(path, pathParams);
    }

    public static WebTestClientResponse put(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().put(path, pathParams);
    }

    public static WebTestClientResponse post(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().post(uriFunction);
    }

    public static WebTestClientResponse post(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().post(uri);
    }

    public static WebTestClientResponse post(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().post(url);
    }

    public static WebTestClientResponse post() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().post();
    }

    public static WebTestClientResponse delete(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().delete(path, pathParams);
    }

    public static WebTestClientResponse put(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().put(path, pathParams);
    }

    public static WebTestClientResponse put(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().put(uriFunction);
    }

    public static WebTestClientResponse put(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().put(uri);
    }

    public static WebTestClientResponse put(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().put(url);
    }

    public static WebTestClientResponse put() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().put();
    }

    public static WebTestClientResponse delete(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().delete(path, pathParams);
    }

    public static WebTestClientResponse head(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().head(path, pathParams);
    }

    public static WebTestClientResponse delete(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().delete(uriFunction);
    }

    public static WebTestClientResponse delete(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().delete(uri);
    }

    public static WebTestClientResponse delete(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().delete(url);
    }

    public static WebTestClientResponse delete() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().delete();
    }

    public static WebTestClientResponse head(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().head(path, pathParams);
    }

    public static WebTestClientResponse patch(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().patch(path, pathParams);
    }

    public static WebTestClientResponse head(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().head(uriFunction);
    }

    public static WebTestClientResponse head(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().head(uri);
    }

    public static WebTestClientResponse head(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().head(url);
    }

    public static WebTestClientResponse head() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().head();
    }

    public static WebTestClientResponse patch(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().patch(path, pathParams);
    }

    public static WebTestClientResponse patch(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().patch(uriFunction);
    }

    public static WebTestClientResponse patch(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().patch(uri);
    }

    public static WebTestClientResponse patch(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().patch(url);
    }

    public static WebTestClientResponse patch() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().patch();
    }

    public static WebTestClientResponse options(String path, Object ... pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().options(path, pathParams);
    }

    public static WebTestClientResponse options(String path, Map<String, ?> pathParams) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().options(path, pathParams);
    }

    public static WebTestClientResponse options(Function<UriBuilder, URI> uriFunction) {
        return RestAssuredWebTestClient.given().options(uriFunction);
    }

    public static WebTestClientResponse options(URI uri) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().options(uri);
    }

    public static WebTestClientResponse options(URL url) {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().options(url);
    }

    public static WebTestClientResponse options() {
        return (WebTestClientResponse)RestAssuredWebTestClient.given().options();
    }

    public static void enableLoggingOfRequestAndResponseIfValidationFails() {
        RestAssuredWebTestClient.enableLoggingOfRequestAndResponseIfValidationFails(LogDetail.ALL);
    }

    public static void enableLoggingOfRequestAndResponseIfValidationFails(LogDetail logDetail) {
        config = config == null ? new RestAssuredWebTestClientConfig() : config;
        config = config.logConfig(LogConfig.logConfig().enableLoggingOfRequestAndResponseIfValidationFails(logDetail));
        if (requestSpecification instanceof WebTestClientRequestSpecificationImpl) {
            RestAssuredWebTestClientConfig restAssuredConfig = ((WebTestClientRequestSpecificationImpl)requestSpecification).getRestAssuredWebTestClientConfig();
            if (restAssuredConfig == null) {
                restAssuredConfig = config;
            } else {
                LogConfig logConfigForRequestSpec = restAssuredConfig.getLogConfig().enableLoggingOfRequestAndResponseIfValidationFails(logDetail);
                restAssuredConfig = restAssuredConfig.logConfig(logConfigForRequestSpec);
            }
            requestSpecification.config(restAssuredConfig);
        }
    }

    public WebTestClientRequestSender when() {
        return RestAssuredWebTestClient.given().when();
    }

    public static RestAssuredWebTestClientConfig config() {
        return config == null ? new RestAssuredWebTestClientConfig() : config;
    }

    static {
        responseSpecification = null;
        basePath = "/";
        webTestClientFactory = null;
    }
}

