/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractArrayCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import java.util.function.Supplier;

final class FloatArrayCodec
extends AbstractArrayCodec<Float> {
    FloatArrayCodec(ByteBufAllocator byteBufAllocator) {
        super(byteBufAllocator, Float.class);
    }

    @Override
    public Parameter encodeNull() {
        return FloatArrayCodec.createNull(PostgresqlObjectId.FLOAT4_ARRAY, Format.FORMAT_TEXT);
    }

    @Override
    Float doDecodeBinary(ByteBuf byteBuffer) {
        return Float.valueOf(byteBuffer.readFloat());
    }

    @Override
    Float doDecodeText(String text) {
        return Float.valueOf(Float.parseFloat(text));
    }

    @Override
    boolean doCanDecode(PostgresqlObjectId type, Format format) {
        Assert.requireNonNull(type, "type must not be null");
        return PostgresqlObjectId.FLOAT4_ARRAY == type;
    }

    @Override
    Parameter encodeArray(Supplier<ByteBuf> encodedSupplier) {
        return FloatArrayCodec.create(PostgresqlObjectId.FLOAT4_ARRAY, Format.FORMAT_TEXT, encodedSupplier);
    }

    @Override
    String doEncodeText(Float value) {
        Assert.requireNonNull(value, "value must not be null");
        return value.toString();
    }
}

