/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.postgresql.client.Parameter;
import io.r2dbc.postgresql.codec.AbstractNumericCodec;
import io.r2dbc.postgresql.message.Format;
import io.r2dbc.postgresql.type.PostgresqlObjectId;
import io.r2dbc.postgresql.util.Assert;
import reactor.util.annotation.Nullable;

final class DoubleCodec
extends AbstractNumericCodec<Double> {
    private final ByteBufAllocator byteBufAllocator;

    DoubleCodec(ByteBufAllocator byteBufAllocator) {
        super(Double.class);
        this.byteBufAllocator = Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
    }

    @Override
    public Parameter encodeNull() {
        return DoubleCodec.createNull(PostgresqlObjectId.FLOAT8, Format.FORMAT_BINARY);
    }

    @Override
    Double doDecode(ByteBuf buffer, PostgresqlObjectId dataType, Format format, @Nullable Class<? extends Double> type) {
        Assert.requireNonNull(buffer, "byteBuf must not be null");
        Assert.requireNonNull(format, "format must not be null");
        return this.decodeNumber(buffer, dataType, format, Double.class, Number::doubleValue);
    }

    @Override
    Parameter doEncode(Double value) {
        Assert.requireNonNull(value, "value must not be null");
        return DoubleCodec.create(PostgresqlObjectId.FLOAT8, Format.FORMAT_BINARY, () -> this.byteBufAllocator.buffer(8).writeDouble(value.doubleValue()));
    }

    @Override
    PostgresqlObjectId getDefaultType() {
        return PostgresqlObjectId.FLOAT8;
    }
}

