/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.message.frontend;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.AbstractReferenceCounted;
import io.r2dbc.postgresql.message.frontend.FrontendMessage;
import io.r2dbc.postgresql.message.frontend.FrontendMessageUtils;
import io.r2dbc.postgresql.util.Assert;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class CopyData
extends AbstractReferenceCounted
implements FrontendMessage {
    private final ByteBuf data;

    public CopyData(ByteBuf data) {
        Assert.requireNonNull(data, "data must not be null");
        this.data = data;
    }

    @Override
    public Publisher<ByteBuf> encode(ByteBufAllocator byteBufAllocator) {
        Assert.requireNonNull(byteBufAllocator, "byteBufAllocator must not be null");
        return Mono.fromSupplier(() -> {
            ByteBuf out = byteBufAllocator.ioBuffer(5 + this.data.readableBytes());
            FrontendMessageUtils.writeByte(out, 100);
            FrontendMessageUtils.writeLengthPlaceholder(out);
            FrontendMessageUtils.writeBytes(out, this.data);
            this.release();
            return FrontendMessageUtils.writeSize(out);
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyData copyData = (CopyData)o;
        return Objects.equals(this.data, copyData.data);
    }

    protected void deallocate() {
        this.data.release();
    }

    public CopyData touch(Object hint) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "CopyData{data=" + this.data + '}';
    }
}

