/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.List;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriterArray;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class VariableProducesHandler
implements ServerRestHandler {
    public static final MessageBodyWriter[] EMPTY = new MessageBodyWriter[0];
    final ServerMediaType mediaTypeList;
    final ServerSerialisers serialisers;

    public VariableProducesHandler(ServerMediaType mediaTypeList, ServerSerialisers serialisers) {
        this.mediaTypeList = mediaTypeList;
        this.serialisers = serialisers;
    }

    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        Object entity = requestContext.getResult();
        if (entity instanceof Response) {
            return;
        }
        if (entity == null) {
            return;
        }
        MediaType res = (MediaType)this.mediaTypeList.negotiateProduces(requestContext.serverRequest().getRequestHeader("Accept")).getKey();
        if (res == null) {
            throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])this.mediaTypeList.getSortedMediaTypes()).build()).build());
        }
        if (MediaTypeHelper.isUnsupportedWildcardSubtype((MediaType)res)) {
            throw new NotAcceptableException();
        }
        List writers = this.serialisers.findWriters(null, entity.getClass(), res, RuntimeType.SERVER);
        if (writers == null || writers.isEmpty()) {
            throw new WebApplicationException(Response.notAcceptable((List)Variant.mediaTypes((MediaType[])this.mediaTypeList.getSortedMediaTypes()).build()).build());
        }
        requestContext.setResponseContentType(res);
        requestContext.setEntityWriter(new FixedEntityWriterArray(writers.toArray(EMPTY), this.serialisers));
    }
}

