/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gcp.functions;

import com.google.cloud.functions.HttpFunction;
import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.Application;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;

public final class QuarkusHttpFunction
implements HttpFunction {
    protected static final String deploymentStatus;
    protected static boolean started;
    private static volatile HttpFunction delegate;

    static void setDelegate(String selectedDelegate) {
        if (selectedDelegate != null) {
            try {
                Class<?> clazz = Class.forName(selectedDelegate, false, Thread.currentThread().getContextClassLoader());
                delegate = (HttpFunction)Arc.container().instance(clazz, new Annotation[0]).get();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void service(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
        if (!started) {
            throw new IOException(deploymentStatus);
        }
        if (delegate == null) {
            throw new IOException("We didn't found any HttpFunction to run (or there is multiple one and none selected inside your application.properties)");
        }
        delegate.service(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        started = false;
        StringWriter error = new StringWriter();
        PrintWriter errorWriter = new PrintWriter((Writer)error, true);
        if (Application.currentApplication() == null) {
            ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(QuarkusHttpFunction.class.getClassLoader());
                Class<?> appClass = Class.forName("io.quarkus.runner.ApplicationImpl");
                String[] args = new String[]{};
                Application app = (Application)appClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                app.start(args);
                errorWriter.println("Quarkus bootstrapped successfully.");
                started = true;
            }
            catch (Exception ex) {
                errorWriter.println("Quarkus bootstrap failed.");
                ex.printStackTrace(errorWriter);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentCl);
            }
        } else {
            errorWriter.println("Quarkus bootstrapped successfully.");
            started = true;
        }
        deploymentStatus = error.toString();
    }
}

