/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.tasks.BaseConfig;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tasks.worker.BuildWorker;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.smallrye.config.Expressions;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.workers.WorkQueue;

abstract class QuarkusBuildTask
extends QuarkusTask {
    private static final String QUARKUS_BUILD_DIR = "quarkus-build";
    private static final String QUARKUS_BUILD_GEN_DIR = "quarkus-build/gen";
    private static final String QUARKUS_BUILD_APP_DIR = "quarkus-build/app";
    private static final String QUARKUS_BUILD_DEP_DIR = "quarkus-build/dep";
    static final String QUARKUS_ARTIFACT_PROPERTIES = "quarkus-artifact.properties";
    static final String NATIVE_SOURCES = "native-sources";
    private final GACTV gactv = new GACTV(this.getProject().getGroup().toString(), this.getProject().getName(), this.getProject().getVersion().toString());

    QuarkusBuildTask(String description) {
        super(description);
    }

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Classpath
    public FileCollection getClasspath() {
        return this.extension().classpath();
    }

    @Input
    public Map<String, String> getCachingRelevantInput() {
        ListProperty<String> vars = this.extension().getCachingRelevantProperties();
        return this.extension().baseConfig().cachingRelevantProperties((List)vars.get());
    }

    PackageConfig.BuiltInType packageType() {
        return this.extension().baseConfig().packageType();
    }

    Path gradleBuildDir() {
        return this.buildDir.toPath();
    }

    Path genBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_GEN_DIR);
    }

    Path appBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_APP_DIR);
    }

    Path depBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_DEP_DIR);
    }

    File artifactProperties() {
        return new File(this.buildDir, QUARKUS_ARTIFACT_PROPERTIES);
    }

    File nativeSources() {
        return new File(this.buildDir, NATIVE_SOURCES);
    }

    File fastJar() {
        return new File(this.buildDir, this.outputDirectory());
    }

    File runnerJar() {
        return new File(this.buildDir, this.runnerJarFileName());
    }

    File nativeRunner() {
        return new File(this.buildDir, this.nativeRunnerFileName());
    }

    String runnerJarFileName() {
        return this.runnerName() + ".jar";
    }

    String nativeRunnerFileName() {
        return this.runnerName();
    }

    String runnerName() {
        return this.runnerBaseName() + this.runnerSuffix();
    }

    String nativeImageSourceJarDirName() {
        return this.runnerBaseName() + "-native-image-source-jar";
    }

    String runnerBaseName() {
        BaseConfig baseConfig = this.extension().baseConfig();
        return baseConfig.packageConfig().outputName.orElseGet(() -> this.extension().finalName());
    }

    String outputDirectory() {
        BaseConfig baseConfig = this.extension().baseConfig();
        return baseConfig.packageConfig().outputDirectory.orElse("quarkus-app");
    }

    private String runnerSuffix() {
        BaseConfig baseConfig = this.extension().baseConfig();
        return baseConfig.packageConfig().getRunnerSuffix();
    }

    ApplicationModel resolveAppModelForBuild() {
        ApplicationModel appModel;
        try {
            appModel = this.extension().getAppModelResolver().resolveModel((ArtifactCoords)this.gactv);
        }
        catch (AppModelResolverException e) {
            throw new GradleException("Failed to resolve Quarkus application model for " + this.getPath(), (Throwable)e);
        }
        return appModel;
    }

    void generateBuild() {
        Path buildDir = this.gradleBuildDir();
        Path genDir = this.genBuildDir();
        PackageConfig.BuiltInType packageType = this.packageType();
        this.getLogger().info("Building Quarkus app for package type {} in {}", (Object)packageType, (Object)genDir);
        QuarkusBuildTask.deleteFileIfExists(genDir.resolve(this.outputDirectory()).resolve("app-cds.jsa"));
        this.getFileSystemOperations().delete(delete -> {
            delete.delete(new Object[]{genDir});
            switch (packageType) {
                case JAR: 
                case FAST_JAR: {
                    delete.delete(new Object[]{buildDir.resolve(this.nativeImageSourceJarDirName())});
                }
                case NATIVE: 
                case NATIVE_SOURCES: {
                    delete.delete(new Object[]{this.fastJar()});
                    break;
                }
                case LEGACY_JAR: 
                case LEGACY: {
                    delete.delete(new Object[]{buildDir.resolve("lib")});
                    break;
                }
                case MUTABLE_JAR: 
                case UBER_JAR: {
                    break;
                }
                default: {
                    throw new GradleException("Unsupported package type " + packageType);
                }
            }
        });
        ApplicationModel appModel = this.resolveAppModelForBuild();
        SmallRyeConfig config = this.extension().buildEffectiveConfiguration(appModel.getAppArtifact()).getConfig();
        Map quarkusProperties = (Map)Expressions.withoutExpansion(() -> {
            HashMap<String, String> values = new HashMap<String, String>();
            for (String key : config.getMapKeys("quarkus").values()) {
                values.put(key, config.getConfigValue(key).getValue());
            }
            return values;
        });
        this.getLogger().info("Starting Quarkus application build for package type {}", (Object)packageType);
        if (this.getLogger().isEnabled(LogLevel.INFO)) {
            this.getLogger().info("Effective properties: {}", (Object)quarkusProperties.entrySet().stream().map(Object::toString).sorted().collect(Collectors.joining("\n    ", "\n    ", "")));
        }
        WorkQueue workQueue = this.workQueue(quarkusProperties, () -> this.extension().buildForkOptions);
        workQueue.submit(BuildWorker.class, params -> {
            params.getBuildSystemProperties().putAll(this.extension().buildSystemProperties(appModel.getAppArtifact(), quarkusProperties));
            params.getBaseName().set((Object)this.extension().finalName());
            params.getTargetDirectory().set(buildDir.toFile());
            params.getAppModel().set((Object)appModel);
            params.getGradleVersion().set((Object)this.getProject().getGradle().getGradleVersion());
        });
        workQueue.await();
        this.getFileSystemOperations().copy(copy -> {
            copy.from(new Object[]{buildDir});
            copy.into((Object)genDir);
            copy.eachFile((Action)new CopyActionDeleteNonWriteableTarget(genDir));
            switch (packageType) {
                case NATIVE: {
                    copy.include(new String[]{this.nativeRunnerFileName()});
                    copy.include(new String[]{this.nativeImageSourceJarDirName() + "/**"});
                }
                case JAR: 
                case FAST_JAR: {
                    copy.include(new String[]{this.outputDirectory() + "/**"});
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                    break;
                }
                case LEGACY_JAR: 
                case LEGACY: {
                    copy.include(new String[]{"lib/**"});
                }
                case MUTABLE_JAR: 
                case UBER_JAR: {
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                    copy.include(new String[]{this.runnerJarFileName()});
                    break;
                }
                case NATIVE_SOURCES: {
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                    copy.include(new String[]{this.nativeImageSourceJarDirName() + "/**"});
                    break;
                }
                default: {
                    throw new GradleException("Unsupported package type " + packageType);
                }
            }
        });
    }

    void abort(String message, Object ... args) {
        this.getLogger().warn(message, args);
        this.getProject().getTasks().stream().filter(t -> t != this).filter(t -> !t.getState().getExecuted()).forEach(t -> t.setEnabled(false));
        throw new StopExecutionException();
    }

    protected static void deleteFileIfExists(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class CopyActionDeleteNonWriteableTarget
    implements Action<FileCopyDetails> {
        private final Path destDir;

        public CopyActionDeleteNonWriteableTarget(Path destDir) {
            this.destDir = destDir;
        }

        public void execute(FileCopyDetails details) {
            Path destFile = this.destDir.resolve(details.getPath());
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isWritable(destFile)) {
                QuarkusBuildTask.deleteFileIfExists(destFile);
            }
        }
    }
}

