/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class QuarkusBuildCacheableAppParts
extends QuarkusBuildTask {
    static final String QUARKUS_ARTIFACT_PROPERTIES = "quarkus-artifact.properties";

    @Inject
    public QuarkusBuildCacheableAppParts() {
        super("Quarkus application build with the ability to cache the built artifacts, excluding dependencies. Do not use this task directly, use 'quarkusBuild'");
    }

    @Internal
    public boolean isCachedByDefault() {
        switch (this.packageType()) {
            case JAR: 
            case FAST_JAR: 
            case LEGACY_JAR: 
            case LEGACY: {
                return true;
            }
        }
        return false;
    }

    @OutputDirectories
    public Map<String, File> getOutputDirectories() {
        HashMap<String, File> outputs = new HashMap<String, File>();
        PackageConfig.BuiltInType packageType = this.packageType();
        switch (packageType) {
            case JAR: 
            case FAST_JAR: 
            case LEGACY_JAR: 
            case LEGACY: 
            case NATIVE: {
                outputs.put("app-build-dir", this.appBuildDir().toFile());
                break;
            }
            case MUTABLE_JAR: 
            case UBER_JAR: 
            case NATIVE_SOURCES: {
                break;
            }
            default: {
                throw new GradleException("Unsupported package type " + packageType);
            }
        }
        return outputs;
    }

    @TaskAction
    public void performQuarkusBuild() {
        Path appDir = this.appBuildDir();
        this.getFileSystemOperations().delete(delete -> delete.delete(new Object[]{appDir}));
        PackageConfig.BuiltInType packageType = this.packageType();
        switch (packageType) {
            case JAR: 
            case FAST_JAR: 
            case NATIVE: {
                this.fastJarBuild();
                break;
            }
            case LEGACY_JAR: 
            case LEGACY: {
                this.legacyJarBuild();
                break;
            }
            case MUTABLE_JAR: 
            case UBER_JAR: 
            case NATIVE_SOURCES: {
                this.getLogger().info("Falling back to 'full quarkus application build' for package type {}, this task's output is empty for this package type", (Object)packageType);
                break;
            }
            default: {
                throw new GradleException("Unsupported package type " + packageType);
            }
        }
    }

    private void legacyJarBuild() {
        this.generateBuild();
        Path genDir = this.genBuildDir();
        Path appDir = this.appBuildDir();
        this.getLogger().info("Synchronizing Quarkus legacy-jar app for package type {} into {}", (Object)this.packageType(), (Object)appDir);
        this.getFileSystemOperations().sync(sync -> {
            sync.into((Object)appDir);
            sync.from(new Object[]{genDir});
            sync.include(new String[]{"**", QUARKUS_ARTIFACT_PROPERTIES});
            sync.exclude(new String[]{"lib/**"});
        });
        this.getFileSystemOperations().copy(copy -> {
            copy.into((Object)appDir);
            copy.from(new Object[]{genDir});
            copy.include(new String[]{"lib/modified-*"});
        });
    }

    private void fastJarBuild() {
        this.generateBuild();
        String outputDirectory = this.outputDirectory();
        Path genDir = this.genBuildDir();
        Path appDir = this.appBuildDir();
        this.getLogger().info("Synchronizing Quarkus fast-jar-like app for package type {} into {}", (Object)this.packageType(), (Object)appDir);
        this.getFileSystemOperations().sync(sync -> {
            sync.into((Object)appDir);
            sync.from(new Object[]{genDir});
            sync.exclude(new String[]{outputDirectory + "/lib/**"});
        });
    }
}

