/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import com.google.common.annotations.VisibleForTesting;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.Expressions;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class EffectiveConfig {
    private final SmallRyeConfig config;
    private final Map<String, String> values;

    private EffectiveConfig(Builder builder) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        configSources.add((ConfigSource)new PropertiesConfigSource(builder.forcedProperties, "forcedProperties", 600));
        configSources.add((ConfigSource)new PropertiesConfigSource(this.asStringMap(builder.taskProperties), "taskProperties", 500));
        configSources.add((ConfigSource)new PropertiesConfigSource(ConfigSourceUtil.propertiesToMap((Properties)System.getProperties()), "System.getProperties()", 400));
        configSources.add((ConfigSource)new EnvConfigSource(300){});
        configSources.add((ConfigSource)new PropertiesConfigSource(builder.buildProperties, "quarkusBuildProperties", 290));
        configSources.add((ConfigSource)new PropertiesConfigSource(this.asStringMap(builder.projectProperties), "projectProperties", 280));
        ClassLoader classLoader = EffectiveConfig.toUrlClassloader(builder.sourceDirectories);
        ApplicationPropertiesConfigSourceLoader.InClassPath applicationProperties = new ApplicationPropertiesConfigSourceLoader.InClassPath();
        configSources.addAll(applicationProperties.getConfigSources(classLoader));
        ApplicationYamlConfigSourceLoader.InClassPath applicationYaml = new ApplicationYamlConfigSourceLoader.InClassPath();
        configSources.addAll((Collection<ConfigSource>)applicationYaml.getConfigSources(classLoader));
        configSources.addAll(PropertiesConfigSourceProvider.classPathSources((String)"META-INF/microprofile-config.properties", (ClassLoader)classLoader));
        this.config = EffectiveConfig.buildConfig(builder.profile, configSources);
        this.values = EffectiveConfig.generateFullConfigMap(this.config);
    }

    public SmallRyeConfig getConfig() {
        return this.config;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    private Map<String, String> asStringMap(Map<String, ?> map) {
        HashMap<String, String> target = new HashMap<String, String>();
        map.forEach((k, v) -> {
            if (v != null) {
                target.put((String)k, v.toString());
            }
        });
        return target;
    }

    @VisibleForTesting
    static Map<String, String> generateFullConfigMap(final SmallRyeConfig config) {
        return (Map)Expressions.withoutExpansion((Supplier)new Supplier<Map<String, String>>(){

            @Override
            public Map<String, String> get() {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String propertyName : config.getPropertyNames()) {
                    String value = config.getRawValue(propertyName);
                    if (value == null) continue;
                    properties.put(propertyName, value);
                }
                return Collections.unmodifiableMap(properties);
            }
        });
    }

    @VisibleForTesting
    static SmallRyeConfig buildConfig(String profile, List<ConfigSource> configSources) {
        return ConfigUtils.emptyConfigBuilder().setAddDiscoveredSecretKeysHandlers(false).setAddDefaultSources(false).withSources(configSources).withProfile(profile).build();
    }

    static Builder builder() {
        return new Builder();
    }

    private static ClassLoader toUrlClassloader(Set<File> sourceDirectories) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File sourceDirectory : sourceDirectories) {
            try {
                urls.add(sourceDirectory.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]));
    }

    static final class Builder {
        private Map<String, String> buildProperties = Collections.emptyMap();
        private Map<String, ?> projectProperties = Collections.emptyMap();
        private Map<String, ?> taskProperties = Collections.emptyMap();
        private Map<String, String> forcedProperties = Collections.emptyMap();
        private Set<File> sourceDirectories = Collections.emptySet();
        private String profile = "prod";

        Builder() {
        }

        EffectiveConfig build() {
            return new EffectiveConfig(this);
        }

        Builder withForcedProperties(Map<String, String> forcedProperties) {
            this.forcedProperties = forcedProperties;
            return this;
        }

        Builder withTaskProperties(Map<String, ?> taskProperties) {
            this.taskProperties = taskProperties;
            return this;
        }

        Builder withBuildProperties(Map<String, String> buildProperties) {
            this.buildProperties = buildProperties;
            return this;
        }

        Builder withProjectProperties(Map<String, ?> projectProperties) {
            this.projectProperties = projectProperties;
            return this;
        }

        Builder withSourceDirectories(Set<File> sourceDirectories) {
            this.sourceDirectories = sourceDirectories;
            return this;
        }

        Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }
    }

    public static class ApplicationYamlConfigSourceLoader
    extends AbstractLocationConfigSourceLoader {
        protected String[] getFileExtensions() {
            return new String[]{"yaml", "yml"};
        }

        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            return new YamlConfigSource(url, ordinal);
        }

        public static class InClassPath
        extends ApplicationYamlConfigSourceLoader
        implements ConfigSourceProvider {
            public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
                ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
                configSources.addAll(this.loadConfigSources("application.yaml", 255, classLoader));
                configSources.addAll(this.loadConfigSources("application.yml", 255, classLoader));
                return configSources;
            }

            protected List<ConfigSource> tryFileSystem(URI uri, int ordinal) {
                return new ArrayList<ConfigSource>();
            }
        }
    }
}

